/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import org.apache.sling.api.SlingHttpServletRequest;

public class State {
    private SlingHttpServletRequest request;
    private Set<String> names;

    public State(@Nonnull SlingHttpServletRequest request) {
        this.request = request;
    }

    @CheckForNull
    public String get(@Nonnull String name) {
        Item i = this.getItem(name);
        return i == null ? null : i.getString();
    }

    @Nonnull
    public String get(@Nonnull String name, @Nonnull String defaultValue) {
        Item i = this.getItem(name);
        return i == null ? defaultValue : i.getString();
    }

    public boolean get(@Nonnull String name, boolean defaultValue) {
        Item i = this.getItem(name);
        if (i == null || !"true".equals(i.getString()) && !"false".equals(i.getString())) {
            return defaultValue;
        }
        return i.getBoolean();
    }

    public int get(@Nonnull String name, int defaultValue) {
        try {
            Item i = this.getItem(name);
            return i == null ? defaultValue : i.getInt();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nonnull
    public Iterator<String> names() {
        if (this.names == null) {
            this.names = new LinkedHashSet<String>();
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (c.isHttpOnly()) continue;
                    this.names.add(c.getName());
                }
            }
        }
        return this.names.iterator();
    }

    @CheckForNull
    public Item getItem(@Nonnull String name) {
        Cookie c = this.request.getCookie(name);
        if (c == null || c.isHttpOnly()) {
            return null;
        }
        try {
            return new ItemImpl(name, URLDecoder.decode(c.getValue(), "utf-8"));
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private class ItemImpl
    implements Item {
        @Nonnull
        private String name;
        @Nonnull
        private String value;

        public ItemImpl(@Nonnull String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public String getString() {
            return this.value;
        }

        @Override
        public boolean getBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        @Override
        public int getInt() throws NumberFormatException {
            return Integer.parseInt(this.value);
        }
    }

    public static interface Item {
        @Nonnull
        public String getName();

        @Nonnull
        public String getString();

        public boolean getBoolean();

        public int getInt() throws NumberFormatException;
    }
}

