/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.FormConfig;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"com.adobe.granite.ui.components.FormRestrict"}, service={Servlet.class})
@SlingServletPaths(value={"/libs/granite/ui/components/formconfig"})
@Designate(ocd=FormConfig.class)
@ServiceDescription(value="Form Restriction Configuration")
public class FormRestrict
extends SlingAllMethodsServlet {
    String[] allowedPaths;
    String restrictBehavior;
    private static final Logger log = LoggerFactory.getLogger(FormRestrict.class);

    protected void setup(FormConfig config) {
        this.allowedPaths = config.allowed_paths();
        this.restrictBehavior = config.restrict_behavior();
    }

    @Activate
    protected void activate(FormConfig config) {
        this.setup(config);
    }

    @Modified
    protected void modified(FormConfig config) {
        this.setup(config);
    }

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!"json".equals(request.getRequestPathInfo().getExtension())) {
            response.sendError(404);
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String path : this.allowedPaths) {
            jsonArray.add(path);
        }
        jsonObject.add("allowedpaths", jsonArray);
        jsonObject.addProperty("restrictbehavior", this.restrictBehavior);
        new Gson().toJson((JsonElement)jsonObject, (Appendable)response.getWriter());
    }
}

