/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SamlCredentials
implements Credentials {
    private static final long serialVersionUID = -2737784478463243439L;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final String userId;
    private final String idp;
    private Set<String> samlGroupIds = new HashSet<String>();

    public SamlCredentials(String userId, String idp, boolean idpNameInUserId) {
        this.userId = idpNameInUserId ? new ExternalIdentityRef(userId, idp).getString() : userId;
        this.idp = idp;
    }

    @NotNull
    public String getIdp() {
        return this.idp;
    }

    @NotNull
    public Set<String> getSamlGroupIds() {
        return this.samlGroupIds;
    }

    public void setSamlGroups(@NotNull Set<String> samlGroupIds) {
        this.samlGroupIds = samlGroupIds;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getAttribute(@NotNull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(@NotNull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    @NotNull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getIdWithIdp(String id) {
        return new ExternalIdentityRef(id, this.idp).getString();
    }
}

