/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.infontformatting.IndicFormatter;

public class KannadaFormatter
extends IndicFormatter {
    @Override
    protected int splitVowelsAndNormalize(AttributedRun run, int start, int limit) {
        block7: while (start < limit) {
            int usv = run.elementAt(start);
            switch (usv) {
                case 3264: {
                    run.replace(start, new int[]{3263, 3285});
                    ++limit;
                    start += 2;
                    continue block7;
                }
                case 3271: {
                    run.replace(start, new int[]{3270, 3285});
                    ++limit;
                    start += 2;
                    continue block7;
                }
                case 3272: {
                    run.replace(start, new int[]{3270, 3286});
                    ++limit;
                    start += 2;
                    continue block7;
                }
                case 3274: {
                    run.replace(start, new int[]{3270, 3266});
                    ++limit;
                    start += 2;
                    continue block7;
                }
                case 3275: {
                    run.replace(start, new int[]{3270, 3266, 3285});
                    limit += 2;
                    start += 3;
                    continue block7;
                }
            }
            ++start;
        }
        return limit;
    }

    @Override
    protected int nukta() {
        return 3260;
    }

    @Override
    protected int virama() {
        return 3277;
    }

    @Override
    protected boolean isConsonant(int usv) {
        return 3221 <= usv && usv <= 3257 || 9676 == usv;
    }

    @Override
    protected boolean hasNukta(int usv) {
        return false;
    }

    @Override
    protected int removeNukta(int usv) {
        return usv;
    }

    @Override
    protected boolean isMark(int usv) {
        return 3073 <= usv && usv <= 3075 || 3260 == usv || 3262 <= usv && usv <= 3286;
    }

    @Override
    protected boolean isIndependentVowel(int usv) {
        return 3205 <= usv && usv <= 3220 || 9676 == usv;
    }

    @Override
    protected IndicFormatter.Position getPosition(int usv) {
        switch (usv) {
            case 3262: 
            case 3263: 
            case 3270: 
            case 3276: {
                return IndicFormatter.Position.topMatra;
            }
            case 3265: 
            case 3266: 
            case 3267: 
            case 3268: 
            case 3285: 
            case 3286: {
                return IndicFormatter.Position.rightMatra;
            }
            case 3073: 
            case 3074: 
            case 3075: {
                return IndicFormatter.Position.rightOther;
            }
        }
        return IndicFormatter.Position.any;
    }

    @Override
    protected IndicFormatter.Shape rephLike(int usv) {
        if (usv == 3248) {
            return IndicFormatter.Shape.rephVowel;
        }
        return IndicFormatter.Shape.any;
    }

    @Override
    protected boolean subjoins(int usv) {
        return this.isConsonant(usv);
    }

    @Override
    protected boolean postjoins(int usv) {
        return false;
    }

    @Override
    protected boolean postjoinsIndependentVowels(int usv) {
        return false;
    }
}

