/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.DigitCase;
import com.adobe.fontengine.inlineformatting.DigitWidth;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FontStyle;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.TypographicCase;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

class GenericFormatter
extends BaseFormatter {
    private static final int[] gsubFeatures = new int[]{Tag.feature_ccmp, Tag.feature_locl, Tag.feature_rtla, Tag.feature_rlig, Tag.feature_liga, Tag.feature_clig, Tag.feature_ital, Tag.feature_titl, Tag.feature_case, Tag.feature_lnum, Tag.feature_onum, Tag.feature_c2sc, Tag.feature_smcp, Tag.feature_c2pc, Tag.feature_pcap, Tag.feature_unic, Tag.feature_dlig, Tag.feature_hlig, Tag.feature_pnum, Tag.feature_tnum};
    private static final int[] gposFeatures = new int[]{Tag.feature_kern, Tag.feature_mark, Tag.feature_mkmk, Tag.feature_cpsp};
    private static final OTSelector italSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.fontStyle);
            return v == FontStyle.ITALIC || v == FontStyle.OBLIQUE;
        }
    };
    private static final OTSelector titlSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.TITLE;
        }
    };
    private static final OTSelector caseSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.TITLE || v == TypographicCase.CAPS;
        }
    };
    private static final OTSelector c2scSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.SMALLCAPS;
        }
    };
    private static final OTSelector smcpSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.SMALLCAPS || v == TypographicCase.CAPS_AND_SMALLCAPS;
        }
    };
    private static final OTSelector c2pcSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.PETITECAPS;
        }
    };
    private static final OTSelector pcapSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.PETITECAPS;
        }
    };
    private static final OTSelector unicSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.UNICASE;
        }
    };
    private static final OTSelector cpspSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.typographicCase);
            return v == TypographicCase.TITLE || v == TypographicCase.CAPS;
        }
    };
    private static final OTSelector lnumSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.digitCase);
            if (v == DigitCase.FROM_TYPOGRAPHIC_CASE) {
                v = run.getElementStyle(position, ElementAttribute.typographicCase);
                return v == TypographicCase.TITLE || v == TypographicCase.CAPS;
            }
            return v == DigitCase.LINING;
        }
    };
    private static final OTSelector onumSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.digitCase);
            if (v == DigitCase.FROM_TYPOGRAPHIC_CASE) {
                v = run.getElementStyle(position, ElementAttribute.typographicCase);
                return v == TypographicCase.TEXT || v == TypographicCase.CAPS_AND_SMALLCAPS || v == TypographicCase.SMALLCAPS || v == TypographicCase.PETITECAPS || v == TypographicCase.UNICASE;
            }
            return v == DigitCase.OLD_STYLE;
        }
    };
    private static final OTSelector tnumSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.digitWidth);
            return v == DigitWidth.TABULAR;
        }
    };
    private static final OTSelector pnumSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.digitWidth);
            return v == DigitWidth.PROPORTIONAL;
        }
    };

    GenericFormatter() {
    }

    protected int setGlyphs(AttributedRun run, int start, int limit, FontData fontData) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (start < limit) {
            int usvc;
            int gid;
            int i;
            int graphemeLimit;
            if (run.getElementStyle(start, ElementAttribute.isGlyph) == Boolean.TRUE) {
                ++start;
                continue;
            }
            int usv = run.elementAt(start);
            if (usv == 8205) {
                run.remove(start);
                --limit;
                run.setInterElementStyleBefore(start, InterElementAttribute.ligatureLevel, LigatureLevel.EXOTIC);
                continue;
            }
            if (usv == 8204) {
                run.remove(start);
                --limit;
                run.setInterElementStyleBefore(start, InterElementAttribute.ligatureLevel, LigatureLevel.NONE);
                continue;
            }
            if (CharUtil.isControl(usv) && !fontData.isSymbolic()) {
                run.remove(start);
                --limit;
                continue;
            }
            if ((Integer)run.getElementStyle(start, ElementAttribute.bidiLevel) % 2 == 1) {
                usv = UCharacter.getMirror(usv);
            }
            if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
                int gid2 = fontData.getGlyphForChar(usv);
                run.replace(start, gid2);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                ++start;
                continue;
            }
            for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
            }
            boolean directMappingHasNotdef = false;
            int[] usvs = new int[graphemeLimit - start];
            int[] gids = new int[graphemeLimit - start];
            for (i = start; i < graphemeLimit; ++i) {
                usvs[i - start] = run.elementAt(i);
                gid = fontData.getGlyphForChar(usvs[i - start]);
                if (gid == 0) {
                    directMappingHasNotdef = true;
                }
                gids[i - start] = gid;
            }
            if (directMappingHasNotdef && (usvc = CharUtil.compose(usvs, 0, graphemeLimit - start)) != -1 && (gid = fontData.getGlyphForChar(usvc)) != 0) {
                run.replace(start, graphemeLimit, gid);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                limit -= graphemeLimit - start - 1;
                ++start;
                continue;
            }
            for (i = start; i < graphemeLimit; ++i) {
                run.replace(i, gids[i - start]);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
            }
            start = graphemeLimit;
        }
        return limit;
    }

    @Override
    protected boolean canFormatOT() {
        return true;
    }

    @Override
    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Integer bidiLevel = (Integer)run.getElementStyle(start, ElementAttribute.bidiLevel);
        int scriptTag = GenericFormatter.getOTScriptTag((Integer)run.getElementStyle(start, InFontFormatter.scriptAttribute));
        int langTag = GenericFormatter.getOTLanguageTag((ULocale)run.getElementStyle(start, ElementAttribute.locale));
        limit = this.setGlyphs(run, start, limit, otFont);
        if (otFont.gsub != null) {
            int[][] gsubLookups = LookupsCache.resolveFeatureTag(otFont.gsub, scriptTag, langTag, gsubFeatures);
            limit = otFont.gsub.applyLookups(gsubLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            if (bidiLevel % 2 == 1) {
                limit = otFont.gsub.applyLookups(gsubLookups[2], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            }
            limit = otFont.gsub.applyLookups(gsubLookups[6], run, start, limit, italSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[7], run, start, limit, titlSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[8], run, start, limit, caseSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[9], run, start, limit, lnumSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[10], run, start, limit, onumSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[18], run, start, limit, pnumSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[19], run, start, limit, tnumSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[11], run, start, limit, c2scSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[12], run, start, limit, smcpSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[13], run, start, limit, c2pcSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[14], run, start, limit, pcapSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[15], run, start, limit, unicSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[3], run, start, limit, OTSelectors.minimumLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[4], run, start, limit, OTSelectors.commonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[5], run, start, limit, OTSelectors.commonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[16], run, start, limit, OTSelectors.uncommonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[17], run, start, limit, OTSelectors.exoticLigatures, otFont.gdef);
        }
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (otFont.gpos != null) {
            int[][] gposLookups = LookupsCache.resolveFeatureTag(otFont.gpos, scriptTag, langTag, gposFeatures);
            if (shouldKern) {
                if (gposLookups[0].length != 0) {
                    limit = otFont.gpos.applyLookups(gposLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
                } else {
                    this.applyKernTable(otFont, run, start, limit);
                }
            }
            limit = otFont.gpos.applyLookups(gposLookups[3], run, start, limit, cpspSelector, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[2], run, start, limit, OTSelectors.everywhere, otFont.gdef);
        } else if (shouldKern) {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    @Override
    protected boolean canFormatTT() {
        return true;
    }

    @Override
    protected int formatTT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit, otFont);
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (shouldKern) {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    @Override
    protected boolean canFormatT1() {
        return true;
    }

    @Override
    protected int formatT1(Type1Font t1Font, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit, t1Font);
        this.posFromAdvanceWidth(run, t1Font, start, limit);
        if (shouldKern) {
            for (int i = start; i < limit - 1; ++i) {
                double kernValue = t1Font.getKernValue(run.elementAt(i), run.elementAt(i + 1));
                run.adjustPlacementAndAdvance(i, 0.0, 0.0, kernValue, 0.0);
            }
        }
        return limit;
    }

    @Override
    protected boolean canFormatGeneric() {
        return true;
    }

    @Override
    protected int formatGeneric(FontData fontData, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit, fontData);
        this.posFromAdvanceWidth(run, fontData, start, limit);
        return limit;
    }
}

