/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.GsubHarvester;
import com.adobe.fontengine.font.opentype.OTFSWFFont3Description;
import com.adobe.fontengine.font.opentype.OTSubset;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

class OTFSWFFont4Description
extends SWFFont4Description {
    private final OTFSWFFont3Description defineFont3Desc;
    private final OpenTypeFont theFont;

    OTFSWFFont4Description(OpenTypeFont theFont, boolean wasEmbedded) throws InvalidFontException, UnsupportedFontException {
        this.theFont = theFont;
        this.defineFont3Desc = new OTFSWFFont3Description(theFont, wasEmbedded);
    }

    @Override
    public boolean canDisplay(int c) throws UnsupportedFontException, InvalidFontException {
        try {
            return this.theFont.cmap.unicodeChar2glyph(c) != 0;
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
    }

    @Override
    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getFirstChar();
    }

    @Override
    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        try {
            if (this.theFont.cmap.symbolSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.symbolSubtableOffset, false);
            }
            if (this.theFont.cmap.unicodeSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.unicodeSubtableOffset, false);
            }
        }
        catch (NullPointerException e) {
            throw new InvalidFontException("Missing required table", e);
        }
        return 65535;
    }

    @Override
    public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getPermissions();
    }

    @Override
    public String getFamily() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getFamily();
    }

    @Override
    public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getSubFamily();
    }

    @Override
    public boolean isBold() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.isBold();
    }

    @Override
    public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.isItalic();
    }

    public void streamFontData(Iterator codepoints, OutputStream stream) throws InvalidFontException, UnsupportedFontException, IOException {
        OTSubset subset = new OTSubset(this.theFont, true);
        TreeSet cps = new TreeSet();
        boolean includeVariationCmap = false;
        if (this.theFont.cmap != null) {
            ArrayList sortedCodepoints = new ArrayList();
            while (codepoints.hasNext()) {
                sortedCodepoints.add(codepoints.next());
            }
            Collections.sort(sortedCodepoints);
            codepoints = sortedCodepoints.iterator();
            includeVariationCmap = this.theFont.cmap.gatherPossibleMappings(codepoints, cps, subset);
        }
        TreeMap<Integer, List> lookups = null;
        if (this.theFont.gsub != null) {
            GsubHarvester harvester = new GsubHarvester(this.theFont.gsub, this.theFont.getNumGlyphs());
            lookups = harvester.gatherPossibleLookups(subset);
        }
        this.theFont.subsetAndStreamForSWFEmbedding(subset, stream, lookups, cps, includeVariationCmap);
    }

    @Override
    public void streamFontData(OutputStream stream) throws InvalidFontException, UnsupportedFontException, IOException {
        this.theFont.streamSFNTForSWFEditting(stream);
    }
}

