/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.Map;

public final class Hhea
extends Table {
    protected Hhea(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
        int majorVersion = this.getTableMajorVersion();
        if (majorVersion != 1) {
            throw new UnsupportedFontException("'hhea' tables with major version " + majorVersion + "are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getNumberOfHMetrics() throws InvalidFontException {
        return this.data.getuint16(34);
    }

    public int getRise() throws InvalidFontException {
        return this.data.getint16(18);
    }

    public int getRun() throws InvalidFontException {
        return this.data.getint16(20);
    }

    public int getAscender() throws InvalidFontException {
        return this.data.getint16(4);
    }

    public int getDescender() throws InvalidFontException {
        return this.data.getint16(6);
    }

    public int getLineGap() throws InvalidFontException {
        return this.data.getint16(8);
    }

    public void subsetAndStream(Subset subset, Map tables) {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        newData.setuint16(34, subset.getNumGlyphs());
        tables.put(new Integer(1751672161), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1751672161), newData);
    }
}

