/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class ContextualGenerator {
    private static final boolean warnAboutDroppedSublookups = false;

    ContextualGenerator() {
    }

    static void gatherCoveragesForSubtable(LayoutTable origTable, int stOffset, int lookupType, int lookupIndex, Integer subtableIndex, Map coverageMapToUse, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int stFormat = origTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: 
            case 2: {
                int coverageOffset = origTable.data.getOffset(stOffset, 2);
                LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                break;
            }
            case 3: {
                int coverageCount = origTable.data.getuint16(stOffset + 2);
                for (int j = 0; j < coverageCount; ++j) {
                    int coverageOffset = origTable.data.getOffset(stOffset, 6 + 2 * j);
                    LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual subtable format (" + stFormat + ")");
            }
        }
    }

    static void patchSubtableCoverage(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Map coverageInfo, int lookupType) throws InvalidFontException {
        int format = origTable.data.getuint16(origSTOffset);
        switch (format) {
            case 1: 
            case 2: {
                LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 2, coverageInfo);
                break;
            }
            case 3: {
                int numCoverages = origTable.data.getuint16(origSTOffset + 2);
                for (int i = 0; i < numCoverages; ++i) {
                    LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 6 + 2 * i, coverageInfo);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type 5 format: " + format);
            }
        }
    }

    static LookupTableSubsetter.LookupSubtableGenerator newContextualGenerator(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Subset subset, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset, int origNumGlyphs) throws InvalidFontException, UnsupportedFontException {
        int format = origTable.data.getuint16(origSTOffset);
        switch (format) {
            case 1: {
                return ContextualFormat1Generator.newInstance(origSTOffset, newSTOffset, origTable, subset, builder, newCoverages, lookupSubset);
            }
            case 2: {
                return ContextualFormat2Generator.newInstance(origTable, subset, builder, newSTOffset, origSTOffset, lookupSubset, origNumGlyphs);
            }
            case 3: {
                return ContextualFormat3Generator.newInstance(origTable, builder, origSTOffset, newSTOffset, newCoverages, lookupSubset);
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format: " + format);
    }

    private static class ContextualFormat3Generator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final int origSTOffset;
        private final int newSTOffset;
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTable origTable;
        private final OTByteArray.OTByteArrayBuilder builder;

        private ContextualFormat3Generator(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset) {
            this.lookupSubset = lookupSubset;
            this.newSTOffset = newSTOffset;
            this.origSTOffset = origSTOffset;
            this.origTable = origTable;
            this.builder = builder;
        }

        static ContextualFormat3Generator newInstance(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset) {
            return new ContextualFormat3Generator(origTable, builder, origSTOffset, newSTOffset, newCoverages, lookupSubset);
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int coverageCount = this.origTable.data.getuint16(this.origSTOffset + 2);
            int substCount = this.origTable.data.getuint16(this.origSTOffset + 4);
            int size = 6 + 2 * coverageCount;
            this.builder.ensureCapacity(this.newSTOffset + size);
            this.builder.setuint16(this.newSTOffset, 3);
            this.builder.setuint16(this.newSTOffset + 2, coverageCount);
            int newSubstCount = 0;
            for (int i = 0; i < substCount; ++i) {
                int origValue = this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * coverageCount + 4 * i + 2);
                int newValue = this.lookupSubset.getExistingSubsetGid(origValue);
                if (newValue == -1) continue;
                this.builder.ensureCapacity(this.newSTOffset + (size += 4));
                this.builder.setuint16(this.newSTOffset + 6 + 2 * coverageCount + 4 * newSubstCount, this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * coverageCount + 4 * i));
                this.builder.setuint16(this.newSTOffset + 6 + 2 * coverageCount + 4 * newSubstCount + 2, newValue);
                ++newSubstCount;
            }
            this.builder.setuint16(this.newSTOffset + 4, newSubstCount);
            return size;
        }
    }

    private static class ContextualFormat2Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTableSubsetter.ClassCoveredBySubset classCovered;
        private final int origClassDefOffset;
        private final int numGlyphs;
        private final int classCount;

        private ContextualFormat2Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int classCount, LookupTableSubsetter.LookupSubset lookupSubset, int numGlyphs) throws InvalidFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, classCount, 6, true, true);
            this.lookupSubset = lookupSubset;
            this.classCovered = new LayoutTableSubsetter.ClassCoveredBySubset(subset);
            this.origClassDefOffset = origTable.data.getOffset(origSTOffset, 4);
            this.numGlyphs = numGlyphs;
            this.classCount = classCount;
        }

        static ContextualFormat2Generator newInstance(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder builder, int newSTOffset, int origSTOffset, LookupTableSubsetter.LookupSubset lookupSubset, int numGlyphs) throws InvalidFontException {
            int classCount = origTable.data.getuint16(origSTOffset + 6);
            ContextualFormat2Generator consumer = new ContextualFormat2Generator(origTable, subset, builder, newSTOffset, origSTOffset, classCount, lookupSubset, numGlyphs);
            return consumer;
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.builder.ensureCapacity(this.newSTOffset + 8 + 2 * this.classCount);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 6, this.classCount);
            this.origTable.iterateCoverage(coverageOffset, this.subset, this);
            this.writeClassDef();
            return this.subtableSize;
        }

        @Override
        boolean[] computeMembersToKeep(int newRuleSetOffset, int origRuleSetOffset) throws InvalidFontException, UnsupportedFontException {
            int origRuleCount = this.origTable.data.getuint16(origRuleSetOffset);
            boolean[] keep = new boolean[origRuleCount];
            Arrays.fill(keep, true);
            block0: for (int i = 0; i < origRuleCount; ++i) {
                int ruleOffset = this.origTable.data.getOffset(origRuleSetOffset, 2 + 2 * i);
                int glyphCount = this.origTable.data.getuint16(ruleOffset);
                for (int j = 0; j < glyphCount - 1; ++j) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, this.origClassDefOffset, this.numGlyphs, this.origTable.data.getuint16(ruleOffset + 4 + 2 * j))) continue;
                    keep[i] = false;
                    continue block0;
                }
            }
            return keep;
        }

        @Override
        int writeMember(int newSubRuleOffset, int origSubRuleOffset) throws InvalidFontException, UnsupportedFontException {
            int glyphCount = this.origTable.data.getuint16(origSubRuleOffset);
            int substCount = this.origTable.data.getuint16(origSubRuleOffset + 2);
            int lSize = 4 + 2 * (glyphCount - 1);
            this.builder.ensureCapacity(newSubRuleOffset + lSize);
            this.builder.setuint16(newSubRuleOffset, glyphCount);
            for (int i = 0; i < glyphCount - 1; ++i) {
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * i, this.origTable.data.getuint16(origSubRuleOffset + 4 + i * 2));
            }
            int newSubstCount = 0;
            for (int i = 0; i < substCount; ++i) {
                int lookup = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 4 + 2 * (glyphCount - 1) + i * 4 + 2));
                if (lookup == -1) continue;
                this.builder.ensureCapacity(newSubRuleOffset + (lSize += 4));
                int origValue = this.origTable.data.getuint16(origSubRuleOffset + 4 + 2 * (glyphCount - 1) + i * 4);
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * (glyphCount - 1) + 4 * newSubstCount, origValue);
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * (glyphCount - 1) + 4 * newSubstCount + 2, lookup);
                ++newSubstCount;
            }
            this.builder.setuint16(newSubRuleOffset + 2, newSubstCount);
            return lSize;
        }

        void writeClassDef() throws InvalidFontException, UnsupportedFontException {
            LayoutTableSubsetter.ClassDefGenerator generator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, this.origClassDefOffset, this.subset, this.numGlyphs);
            this.builder.setuint16(this.newSTOffset + 4, this.subtableSize);
            OTByteArray array = generator.generateClass().toOTByteArray();
            this.subtableSize += this.writeByteArrayAtOffset(this.newSTOffset + this.subtableSize, array);
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) throws InvalidFontException {
            return this.origTable.getClassIndex(gid, this.origClassDefOffset);
        }

        @Override
        int getOrigRecordSize() {
            return 0;
        }
    }

    private static class ContextualFormat1Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;

        private ContextualFormat1Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int subRuleSetCount, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, subRuleSetCount, 4, false, true);
            this.writeHeader(newSTOffset, subRuleSetCount);
            this.lookupSubset = lookupSubset;
        }

        private void writeHeader(int newSTOffset, int glyphCount) {
            this.builder.ensureCapacity(newSTOffset + 6 + 2 * glyphCount);
            this.builder.setuint16(newSTOffset, 1);
            this.builder.setuint16(newSTOffset + 4, glyphCount);
        }

        static ContextualFormat1Generator newInstance(int origSTOffset, int newSTOffset, LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder builder, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = origTable.data.getOffset(origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)newCoverages.get(new Integer(coverageOffset));
            ContextualFormat1Generator consumer = new ContextualFormat1Generator(origTable, subset, builder, newSTOffset, origSTOffset, newCoverage.glyphCount, lookupSubset);
            origTable.iterateCoverage(coverageOffset, subset, consumer);
            return consumer;
        }

        @Override
        boolean[] computeMembersToKeep(int newRuleSetOffset, int origRuleSetOffset) throws InvalidFontException, UnsupportedFontException {
            int origRuleCount = this.origTable.data.getuint16(origRuleSetOffset);
            boolean[] keep = new boolean[origRuleCount];
            Arrays.fill(keep, true);
            block0: for (int i = 0; i < origRuleCount; ++i) {
                int ruleOffset = this.origTable.data.getOffset(origRuleSetOffset, 2 + 2 * i);
                int glyphCount = this.origTable.data.getuint16(ruleOffset);
                for (int j = 0; j < glyphCount - 1; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(ruleOffset + 4 + 2 * j)) != -1) continue;
                    keep[i] = false;
                    continue block0;
                }
            }
            return keep;
        }

        @Override
        int writeMember(int newSubRuleOffset, int origSubRuleOffset) throws InvalidFontException, UnsupportedFontException {
            int glyphCount = this.origTable.data.getuint16(origSubRuleOffset);
            int substCount = this.origTable.data.getuint16(origSubRuleOffset + 2);
            int lSize = 4 + 2 * (glyphCount - 1);
            this.builder.ensureCapacity(newSubRuleOffset + lSize);
            this.builder.setuint16(newSubRuleOffset, glyphCount);
            for (int i = 0; i < glyphCount - 1; ++i) {
                int gid = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 4 + i * 2));
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * i, gid);
            }
            int newSubstCount = 0;
            for (int i = 0; i < substCount; ++i) {
                int newLookup = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 4 + 2 * (glyphCount - 1) + i * 4 + 2));
                if (newLookup == -1) continue;
                this.builder.ensureCapacity(newSubRuleOffset + (lSize += 4));
                int origValue = this.origTable.data.getuint16(origSubRuleOffset + 4 + 2 * (glyphCount - 1) + i * 4);
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * (glyphCount - 1) + 4 * newSubstCount, origValue);
                this.builder.setuint16(newSubRuleOffset + 4 + 2 * (glyphCount - 1) + 4 * newSubstCount + 2, newLookup);
                ++newSubstCount;
            }
            this.builder.setuint16(newSubRuleOffset + 2, newSubstCount);
            return lSize;
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) {
            return coverageIndex;
        }

        @Override
        int getOrigRecordSize() {
            return 0;
        }
    }
}

