/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.Type2UnhintedRedirector;
import java.util.ArrayList;
import java.util.ListIterator;

final class Type2HintedRedirector
extends Type2UnhintedRedirector {
    private ArrayList a = new ArrayList();
    private int lastHintRedirected = -1;
    private int seacHintBase = 0;
    private boolean hintmaskSeen = false;
    private boolean newHints = false;

    Type2HintedRedirector() {
    }

    @Override
    void reset(OutlineConsumer outlineConsumer) {
        super.reset(outlineConsumer);
        this.a.clear();
        this.hintmaskSeen = false;
        this.newHints = false;
        this.lastHintRedirected = -1;
    }

    @Override
    public void cntrmask(double[] stack, int stackDepth, CFFByteArray data, int offset, int length) throws InvalidFontException {
        this.processMask(data, offset, length, true);
    }

    @Override
    public void endchar(double[] stack, int stackDepth) {
        this.outlineConsumer.endchar();
    }

    private void addMask() {
        if (!this.hintmaskSeen || this.newHints) {
            boolean startNewGroup = this.hintmaskSeen;
            int i = this.lastHintRedirected + 1;
            ListIterator iter = this.a.listIterator(i);
            while (iter.hasNext()) {
                Stem s = (Stem)iter.next();
                ((HintedOutlineConsumer)this.outlineConsumer).stem(s.e1, s.e2, startNewGroup, s.isVertical, false);
                ++this.lastHintRedirected;
                startNewGroup = false;
            }
            this.hintmaskSeen = true;
            this.newHints = false;
        }
    }

    @Override
    public void rmoveto(double[] stack, int stackDepth) {
        this.addMask();
        super.rmoveto(stack, stackDepth);
    }

    @Override
    public void hmoveto(double[] stack, int stackDepth) {
        this.addMask();
        super.hmoveto(stack, stackDepth);
    }

    @Override
    public void vmoveto(double[] stack, int stackDepth) {
        this.addMask();
        super.vmoveto(stack, stackDepth);
    }

    @Override
    public void moveto(double[] stack, int stackDepth) {
        this.addMask();
        super.moveto(stack, stackDepth);
    }

    @Override
    public void flex(double[] stack, int stackDepth) {
        int i = 0;
        this.x += stack[i++];
        this.y += stack[i++];
        double x1 = this.x;
        double y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x4 = this.x;
        double y4 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x5 = this.x;
        double y5 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        ((HintedOutlineConsumer)this.outlineConsumer).flex(stack[i], x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, this.x, this.y);
    }

    @Override
    public void flex1(double[] stack, int stackDepth) {
        int i = 0;
        double startx = this.x;
        double starty = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x1 = this.x;
        double y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x3 = this.x;
        double y3 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x4 = this.x;
        double y4 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x5 = this.x;
        double y5 = this.y;
        if (Math.abs(this.x - startx) > Math.abs(this.y - starty)) {
            this.x += stack[i++];
            this.y = starty;
        } else {
            this.y += stack[i++];
            this.x = startx;
        }
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, this.x, this.y);
    }

    @Override
    public void hflex(double[] stack, int stackDepth) {
        int i = 0;
        double starty = this.y;
        this.x += stack[i++];
        double x1 = this.x;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        this.x += stack[i++];
        double x3 = this.x;
        this.x += stack[i++];
        double x4 = this.x;
        this.x += stack[i++];
        double x5 = this.x;
        this.x += stack[i++];
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, x1, starty, x2, this.y, x3, this.y, x4, this.y, x5, starty, this.x, starty);
        this.y = starty;
    }

    @Override
    public void hflex1(double[] stack, int stackDepth) {
        int i = 0;
        double startY = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x1 = this.x;
        double y1 = this.y;
        this.x += stack[i++];
        this.y += stack[i++];
        double x2 = this.x;
        double y2 = this.y;
        this.x += stack[i++];
        double x3 = this.x;
        this.x += stack[i++];
        double x4 = this.x;
        this.x += stack[i++];
        this.y += stack[i++];
        double x5 = this.x;
        double y5 = this.y;
        this.x += stack[i++];
        this.y = startY;
        ((HintedOutlineConsumer)this.outlineConsumer).flex(50.0, x1, y1, x2, y2, x3, y2, x4, y2, x5, y5, this.x, this.y);
    }

    private void processMask(CFFByteArray data, int offset, int length, boolean isCounter) throws InvalidFontException {
        int i;
        boolean byteOn = false;
        boolean startNewGroup = isCounter || this.hintmaskSeen;
        for (i = 0; i < length; ++i) {
            if (data.getcard8(offset + i) == 0) continue;
            byteOn = true;
        }
        if (byteOn) {
            for (i = 0; i < length; ++i) {
                int value = data.getcard8(offset + i);
                if (value == 0) continue;
                for (int j = 7; j >= 0; --j) {
                    if ((value & 1 << j) == 0) continue;
                    int stemIndex = i * 8 + (7 - j) + this.seacHintBase;
                    if (stemIndex >= this.a.size()) {
                        throw new InvalidGlyphException("Invalid hint mask");
                    }
                    Stem s = (Stem)this.a.get(stemIndex);
                    ((HintedOutlineConsumer)this.outlineConsumer).stem(s.e1, s.e2, startNewGroup, s.isVertical, isCounter);
                    startNewGroup = false;
                }
            }
        } else if (isCounter) {
            ((HintedOutlineConsumer)this.outlineConsumer).noCounters();
        } else {
            ((HintedOutlineConsumer)this.outlineConsumer).noHints();
        }
    }

    @Override
    public void hintmask(double[] stack, int stackDepth, CFFByteArray data, int offset, int length) throws InvalidFontException {
        this.processMask(data, offset, length, false);
        this.hintmaskSeen = true;
        this.newHints = false;
    }

    private void addStem(double[] stack, int stackDepth, boolean isVertical) {
        int i;
        double e1 = 0.0;
        if (!this.newHints) {
            this.seacHintBase = this.a.size();
            this.lastHintRedirected = this.seacHintBase - 1;
            this.newHints = true;
        }
        int n = i = stackDepth % 2 != 0 ? 1 : 0;
        while (i < stackDepth) {
            double e2 = (e1 += stack[i++]) + stack[i++];
            this.a.add(new Stem(e1, e2, isVertical));
            e1 = e2;
        }
    }

    @Override
    public void hstem(double[] stack, int stackDepth) {
        this.addStem(stack, stackDepth, false);
    }

    @Override
    public void hstemhm(double[] stack, int stackDepth) {
        this.hstem(stack, stackDepth);
    }

    @Override
    public void implicit_vstemhm(double[] stack, int stackDepth) {
        this.vstem(stack, stackDepth);
    }

    @Override
    public void vstem(double[] stack, int stackDepth) {
        this.addStem(stack, stackDepth, true);
    }

    @Override
    public void vstemhm(double[] stack, int stackDepth) {
        this.vstem(stack, stackDepth);
    }

    @Override
    public boolean width(double w) {
        return ((HintedOutlineConsumer)this.outlineConsumer).width(w);
    }

    @Override
    public void globalColorMe(double[] stack, int stackDepth) {
        ((HintedOutlineConsumer)this.outlineConsumer).globalColorOn();
    }

    private static class Stem {
        final double e1;
        final double e2;
        final boolean isVertical;

        Stem(double e1, double e2, boolean isVertical) {
            this.e1 = e1;
            this.e2 = e2;
            this.isVertical = isVertical;
        }
    }
}

