/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;

final class Charset {
    public final CFFByteArray data;
    public final int offset;
    public final int size;
    private static final int[] isoAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] expertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 27, 28, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    private static final int[] expertSubsetCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};

    Charset(CFFByteArray data, int offset, int numGlyphs) throws InvalidFontException {
        this.data = offset < 3 ? null : data;
        this.offset = offset;
        this.size = this.size(numGlyphs);
    }

    Charset(CFFByteArray data) {
        this.data = data;
        this.offset = 0;
        this.size = data.getSize();
    }

    static Charset identityCharset(int numGlyphs) {
        CFFByteArray.CFFByteArrayBuilder bb;
        if ((numGlyphs -= 2) > 255) {
            bb = CFFByteArray.getCFFByteArrayBuilderInstance(5);
            bb.addCard8(2);
            bb.addCard16(1);
            bb.addCard16(numGlyphs);
        } else {
            bb = CFFByteArray.getCFFByteArrayBuilderInstance(4);
            bb.addCard8(1);
            bb.addCard16(1);
            bb.addCard8(numGlyphs);
        }
        return new Charset(bb.toCFFByteArray());
    }

    private static Charset format0Generator(Charset sourceCharset, Subset subset) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder bb = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 2 * (subset.getNumGlyphs() - 1));
        bb.addCard8(0);
        for (int i = 1; i < subset.getNumGlyphs(); ++i) {
            bb.addCard16(sourceCharset.gid2sid(subset.getFullGid(i)));
        }
        return new Charset(bb.toCFFByteArray());
    }

    private static Charset format1Generator(Charset sourceCharset, Subset subset, int numRanges) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder bb = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 3 * numRanges);
        bb.addCard8(1);
        int currEntries = 0;
        int lastSid = sourceCharset.gid2sid(subset.getFullGid(1));
        bb.addCard16(lastSid);
        for (int i = 2; i < subset.getNumGlyphs(); ++i) {
            int thisSid = sourceCharset.gid2sid(subset.getFullGid(i));
            if (currEntries == 255 || thisSid != lastSid + 1) {
                bb.addCard8(currEntries);
                currEntries = 0;
                bb.addCard16(thisSid);
            } else {
                ++currEntries;
            }
            lastSid = thisSid;
        }
        bb.addCard8(currEntries);
        return new Charset(bb.toCFFByteArray());
    }

    private static Charset format2Generator(Charset sourceCharset, Subset subset, int numRanges) throws UnsupportedFontException, InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder bb = CFFByteArray.getCFFByteArrayBuilderInstance(1 + 3 * numRanges);
        bb.addCard8(2);
        int currEntries = 0;
        int lastSid = sourceCharset.gid2sid(subset.getFullGid(1));
        bb.addCard16(lastSid);
        for (int i = 2; i < subset.getNumGlyphs(); ++i) {
            int thisSid = sourceCharset.gid2sid(subset.getFullGid(i));
            if (thisSid != lastSid + 1) {
                bb.addCard16(currEntries);
                currEntries = 0;
                bb.addCard16(thisSid);
            } else {
                ++currEntries;
            }
            lastSid = thisSid;
        }
        bb.addCard8(currEntries);
        return new Charset(bb.toCFFByteArray());
    }

    static Charset charSetFromSubset(Charset sourceCharset, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int numGlyphs = subset.getNumGlyphs();
        int format0Size = 2 * numGlyphs;
        int numRange1 = 1;
        int numRange2 = 1;
        int currRange1Entries = 0;
        if (numGlyphs > 1) {
            int lastSid = sourceCharset.gid2sid(subset.getFullGid(1));
            for (int i = 2; i < numGlyphs; ++i) {
                int thisSid = sourceCharset.gid2sid(subset.getFullGid(i));
                if (currRange1Entries == 255 || thisSid != lastSid + 1) {
                    ++numRange1;
                    currRange1Entries = 0;
                } else {
                    ++currRange1Entries;
                }
                if (thisSid != lastSid + 1) {
                    ++numRange2;
                }
                lastSid = thisSid;
            }
        }
        int format1Size = 3 * numRange1;
        int format2Size = 4 * numRange2;
        if (format0Size <= format1Size) {
            if (format0Size <= format2Size) {
                return Charset.format0Generator(sourceCharset, subset);
            }
            return Charset.format2Generator(sourceCharset, subset, numRange2);
        }
        if (format1Size <= format2Size) {
            return Charset.format1Generator(sourceCharset, subset, numRange1);
        }
        return Charset.format2Generator(sourceCharset, subset, numRange2);
    }

    public int gid2sid(int gid) throws InvalidFontException, UnsupportedFontException {
        if (gid == 0) {
            return 0;
        }
        if (this.data == null) {
            if (this.offset == 0) {
                return isoAdobeCharset[gid];
            }
            if (this.offset == 1) {
                return expertCharset[gid];
            }
            if (this.offset == 2) {
                return expertSubsetCharset[gid];
            }
            throw new InvalidFontException("invalid charset offset (" + this.offset + ")");
        }
        int o = this.offset;
        int format = this.data.getcard8(o);
        ++o;
        switch (format) {
            case 0: {
                return this.data.getcard16(o + 2 * (gid - 1));
            }
            case 1: {
                int currentGid = 1;
                while (o < this.offset + this.size) {
                    int currentSID = this.data.getcard16(o);
                    int nLeft = this.data.getcard8(o += 2);
                    ++o;
                    if (currentGid <= gid && gid <= currentGid + nLeft) {
                        return currentSID + (gid - currentGid);
                    }
                    currentGid += nLeft + 1;
                }
                return -1;
            }
            case 2: {
                int currentGid = 1;
                while (o < this.offset + this.size) {
                    int currentSID = this.data.getcard16(o);
                    int nLeft = this.data.getcard16(o += 2);
                    o += 2;
                    if (currentGid <= gid && gid <= currentGid + nLeft) {
                        return currentSID + (gid - currentGid);
                    }
                    currentGid += nLeft + 1;
                }
                return -1;
            }
        }
        throw new UnsupportedFontException("CFF charset in format " + format);
    }

    public int sid2gid(int sid) throws InvalidFontException, UnsupportedFontException {
        if (sid == 0) {
            return 0;
        }
        if (this.data == null) {
            if (this.offset == 0) {
                for (int gid = 0; gid < isoAdobeCharset.length; ++gid) {
                    if (isoAdobeCharset[gid] != sid) continue;
                    return gid;
                }
                return -1;
            }
            if (this.offset == 1) {
                for (int gid = 0; gid < expertCharset.length; ++gid) {
                    if (expertCharset[gid] != sid) continue;
                    return gid;
                }
                return -1;
            }
            if (this.offset == 2) {
                for (int gid = 0; gid < expertSubsetCharset.length; ++gid) {
                    if (expertSubsetCharset[gid] != sid) continue;
                    return gid;
                }
                return -1;
            }
            throw new InvalidFontException("invalid charset offset (" + this.offset + ")");
        }
        int o = this.offset;
        int format = this.data.getcard8(o);
        ++o;
        switch (format) {
            case 0: {
                int gid = 1;
                while (o < this.offset + this.size) {
                    if (this.data.getcard16(o) == sid) {
                        return gid;
                    }
                    o += 2;
                    ++gid;
                }
                return -1;
            }
            case 1: {
                int currentGid = 1;
                while (o < this.offset + this.size) {
                    int currentSid = this.data.getcard16(o);
                    int nLeft = this.data.getcard8(o += 2);
                    ++o;
                    if (currentSid <= sid && sid <= currentSid + nLeft) {
                        return currentGid + (sid - currentSid);
                    }
                    currentGid += nLeft + 1;
                }
                return -1;
            }
            case 2: {
                int currentGid = 1;
                while (o < this.offset + this.size) {
                    int currentSid = this.data.getcard16(o);
                    int nLeft = this.data.getcard16(o += 2);
                    o += 2;
                    if (currentSid <= sid && sid <= currentSid + nLeft) {
                        return currentGid + (sid - currentSid);
                    }
                    currentGid += nLeft + 1;
                }
                return -1;
            }
        }
        throw new UnsupportedFontException("CFF charset in format " + format);
    }

    int size(int numGlyphs) throws InvalidFontException {
        if (this.offset < 3) {
            return 0;
        }
        int o = this.offset;
        int format = this.data.getcard8(o);
        ++o;
        switch (format) {
            case 0: {
                return 1 + 2 * numGlyphs;
            }
            case 1: {
                int nLeft;
                for (int currentGlyphID = 1; currentGlyphID < numGlyphs; currentGlyphID += nLeft + 1) {
                    nLeft = this.data.getcard8(o += 2);
                    ++o;
                }
                break;
            }
            case 2: {
                int nLeft;
                for (int currentGlyphID = 1; currentGlyphID < numGlyphs; currentGlyphID += nLeft + 1) {
                    nLeft = this.data.getcard16(o += 2);
                    o += 2;
                }
                break;
            }
        }
        return o - this.offset;
    }

    public int predefinedOffset() {
        if (this.data == null) {
            return this.offset;
        }
        return -1;
    }

    public void stream(CFFByteArray.CFFByteArrayBuilder bb) throws InvalidFontException {
        if (this.data != null) {
            bb.addBytes(this.data, this.offset, this.size);
        }
    }

    static void streamCharSet(CFFByteArray.CFFByteArrayBuilder bb, int[] glyphSids) {
        int j;
        int format0Size = (glyphSids.length - 1) * 2;
        int format2Size = 0;
        int i = 1;
        while (i < glyphSids.length && (format2Size += 4) < format0Size) {
            for (j = i + 1; j < glyphSids.length && glyphSids[j] == glyphSids[j - 1] + 1; ++j) {
            }
            i = j;
        }
        if (format2Size < format0Size) {
            bb.addCard8(2);
            i = 1;
            while (i < glyphSids.length) {
                int nleft = 0;
                bb.addCard16(glyphSids[i]);
                for (j = i + 1; j < glyphSids.length && glyphSids[j] == glyphSids[j - 1] + 1; ++j) {
                    ++nleft;
                }
                bb.addCard16(nleft);
                i = j;
            }
        } else {
            bb.addCard8(0);
            for (i = 1; i < glyphSids.length; ++i) {
                bb.addCard16(glyphSids[i]);
            }
        }
    }
}

