/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class IteratingOutlineConsumer
implements OutlineConsumer {
    List elements = new ArrayList();

    IteratingOutlineConsumer() {
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        this.elements.add(new Element(x2, y2, x3, y3, x4, y4));
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3) {
        this.elements.add(new Element(x2, y2, x3, y3));
    }

    @Override
    public void endchar() {
    }

    @Override
    public void lineto(double x, double y) {
        this.elements.add(new Element(ElementType.line, x, y));
    }

    @Override
    public void moveto(double x, double y) {
        this.elements.add(new Element(ElementType.move, x, y));
    }

    @Override
    public void setMatrix(Matrix newMatrix) {
    }

    Iterator iterator() {
        return this.elements.iterator();
    }

    static final class ElementType {
        private String type;
        static final ElementType move = new ElementType("move");
        static final ElementType quad = new ElementType("quadratic");
        static final ElementType cube = new ElementType("cubic");
        static final ElementType line = new ElementType("line");

        private ElementType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    static final class Element {
        ElementType type;
        double x1;
        double y1;
        double x2;
        double y2;
        double x3;
        double y3;

        Element(ElementType type, double x1, double y1) {
            this.type = type;
            this.x1 = x1;
            this.y1 = y1;
        }

        Element(double x1, double y1, double x2, double y2) {
            this.type = ElementType.quad;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        Element(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.type = ElementType.cube;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
        }
    }
}

