/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sightly;

import com.day.cq.wcm.api.WCMMode;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SightlyWCMMode {
    private final boolean isDisabled;
    private final boolean isPreview;
    private final boolean isAnalytics;
    private final boolean isReadOnly;
    private final boolean isEdit;
    private final boolean isDesign;
    private final SlingHttpServletRequest request;
    private final WCMMode mode;

    public SightlyWCMMode(SlingHttpServletRequest request) {
        this.request = request;
        this.mode = WCMMode.fromRequest(request);
        this.isEdit = this.mode == WCMMode.EDIT;
        this.isDesign = this.mode == WCMMode.DESIGN;
        this.isDisabled = this.mode == WCMMode.DISABLED;
        this.isPreview = this.mode == WCMMode.PREVIEW;
        this.isAnalytics = this.mode == WCMMode.ANALYTICS;
        this.isReadOnly = this.mode == WCMMode.READ_ONLY;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public boolean isAnalytics() {
        return this.isAnalytics;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public boolean isDesign() {
        return this.isDesign;
    }

    public String toString() {
        return this.mode.name();
    }
}

