/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.DeferredPromiseImpl;
import org.osgi.util.promise.FailedPromiseImpl;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.ResolvedPromiseImpl;
import org.osgi.util.promise.Success;

abstract class PromiseImpl<T>
implements Promise<T> {
    private final PromiseFactory factory;
    private final ConcurrentLinkedQueue<Runnable> callbacks;

    PromiseImpl(PromiseFactory factory) {
        this.factory = Objects.requireNonNull(factory);
        this.callbacks = new ConcurrentLinkedQueue();
    }

    <V> DeferredPromiseImpl<V> deferred() {
        return new DeferredPromiseImpl(this.factory);
    }

    <V> ResolvedPromiseImpl<V> resolved(V v) {
        return new ResolvedPromiseImpl<V>(v, this.factory);
    }

    <V> FailedPromiseImpl<V> failed(Throwable f) {
        return new FailedPromiseImpl(f, this.factory);
    }

    @Override
    public Promise<T> onResolve(Runnable callback) {
        Objects.requireNonNull(callback);
        if (this.isDone() && (callback instanceof InlineCallback || this.factory.allowCurrentThread())) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
        } else {
            this.callbacks.offer(callback);
            this.notifyCallbacks();
        }
        return this;
    }

    void notifyCallbacks() {
        Runnable callback;
        if (!this.isDone()) {
            return;
        }
        while ((callback = this.callbacks.poll()) != null) {
            this.execute(callback);
        }
    }

    void execute(Runnable operation) {
        try {
            try {
                this.factory.executor().execute(operation);
            }
            catch (RejectedExecutionException e) {
                operation.run();
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
    }

    ScheduledFuture<?> schedule(Runnable operation, long delay, TimeUnit unit) {
        try {
            try {
                return this.factory.scheduledExecutor().schedule(operation, delay, unit);
            }
            catch (RejectedExecutionException e) {
                this.execute(operation);
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
        return null;
    }

    static void uncaughtException(Throwable t) {
        try {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Promise<T> onSuccess(Consumer<? super T> success) {
        return this.onResolve(new OnSuccess(success));
    }

    @Override
    public Promise<T> onFailure(Consumer<? super Throwable> failure) {
        return this.onResolve(new OnFailure(failure));
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Then<T>(deferredPromiseImpl, this, success, failure));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    @Override
    public Promise<T> thenAccept(Consumer<? super T> consumer) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.ThenAccept(deferredPromiseImpl, this, consumer));
        return chained.orDone();
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Filter(deferredPromiseImpl, this, predicate));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Map<T>(deferredPromiseImpl, this, mapper));
        return chained.orDone();
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> mapper) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.FlatMap<T>(deferredPromiseImpl, this, mapper));
        return chained.orDone();
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Recover(deferredPromiseImpl, this, recovery));
        return chained.orDone();
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.RecoverWith(deferredPromiseImpl, this, recovery));
        return chained.orDone();
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.FallbackTo(deferredPromiseImpl, this, fallback));
        return chained.orDone();
    }

    @Override
    public Promise<T> timeout(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Timeout(deferredPromiseImpl, this, millis));
        return chained.orDone();
    }

    @Override
    public Promise<T> delay(long millis) {
        DeferredPromiseImpl chained;
        DeferredPromiseImpl deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        this.onResolve(new DeferredPromiseImpl.Delay(deferredPromiseImpl, this, millis));
        return chained.orDone();
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onResolve(new ToCompletionStage(completableFuture));
        return completableFuture;
    }

    abstract void result(Result<? super T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> void result(Promise<? extends R> promise, Result<? super R> consumer) {
        Object value;
        Throwable fail;
        if (promise instanceof PromiseImpl) {
            PromiseImpl impl = (PromiseImpl)promise;
            impl.result(consumer);
            return;
        }
        if (!promise.isDone()) {
            consumer.accept(null, (Throwable)((Object)new AssertionError((Object)"promise not resolved")));
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            fail = promise.getFailure();
            value = fail == null ? (Object)promise.getValue() : null;
        }
        catch (Throwable e) {
            fail = e;
            value = null;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        consumer.accept(value, fail);
    }

    static interface Result<R> {
        public void accept(R var1, Throwable var2);
    }

    private final class ToCompletionStage
    implements Runnable,
    Result<T> {
        private final CompletableFuture<T> completableFuture;

        ToCompletionStage(CompletableFuture<T> completableFuture) {
            this.completableFuture = Objects.requireNonNull(completableFuture);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                this.completableFuture.complete(v);
            } else {
                this.completableFuture.completeExceptionally(f);
            }
        }
    }

    private final class OnFailure
    implements Runnable,
    Result<T> {
        private final Consumer<? super Throwable> failure;

        OnFailure(Consumer<? super Throwable> failure) {
            this.failure = Objects.requireNonNull(failure);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f != null) {
                try {
                    this.failure.accept(f);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    private final class OnSuccess
    implements Runnable,
    Result<T> {
        private final Consumer<? super T> success;

        OnSuccess(Consumer<? super T> success) {
            this.success = Objects.requireNonNull(success);
        }

        @Override
        public void run() {
            PromiseImpl.this.result(this);
        }

        @Override
        public void accept(T v, Throwable f) {
            if (f == null) {
                try {
                    this.success.accept(v);
                }
                catch (Throwable e) {
                    PromiseImpl.uncaughtException(e);
                }
            }
        }
    }

    static interface InlineCallback {
    }
}

