/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.function;

import java.util.Objects;
import java.util.function.Supplier;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.util.function.Exceptions;

@FunctionalInterface
@ConsumerType
public interface Function<T, R> {
    public R apply(T var1) throws Exception;

    default public <S> Function<T, S> andThen(Function<? super R, ? extends S> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    default public <S> Function<S, R> compose(Function<? super S, ? extends T> before) {
        Objects.requireNonNull(before);
        return s -> this.apply(before.apply((Object)s));
    }

    public static <T, R> java.util.function.Function<T, R> asJavaFunction(Function<T, R> wrapped) {
        Objects.requireNonNull(wrapped);
        return t -> {
            try {
                return wrapped.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.throwUnchecked(e);
            }
        };
    }

    public static <T, R> java.util.function.Function<T, R> asJavaFunctionOrElse(Function<T, R> wrapped, R orElse) {
        Objects.requireNonNull(wrapped);
        return t -> {
            try {
                return wrapped.apply(t);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    public static <T, R> java.util.function.Function<T, R> asJavaFunctionOrElseGet(Function<T, R> wrapped, Supplier<? extends R> orElseGet) {
        Objects.requireNonNull(wrapped);
        return t -> {
            try {
                return wrapped.apply(t);
            }
            catch (Exception e) {
                return orElseGet.get();
            }
        };
    }

    public static <T, R> Function<T, R> asFunction(java.util.function.Function<T, R> wrapped) {
        Objects.requireNonNull(wrapped);
        return wrapped::apply;
    }
}

