/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.compiler.CompilationResult;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.impl.compiler.CompilationResultImpl;
import org.apache.sling.scripting.sightly.impl.compiler.CompilerMessageImpl;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.debug.SanityChecker;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.SimpleFrontend;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.CoalescingWrites;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.DeadCodeRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.SequenceStreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.SyntheticMapRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.UnusedVariableRemoval;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.reduce.ConstantFolding;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.filter.FormatFilter;
import org.apache.sling.scripting.sightly.impl.filter.I18nFilter;
import org.apache.sling.scripting.sightly.impl.filter.JoinFilter;
import org.apache.sling.scripting.sightly.impl.filter.URIManipulationFilter;
import org.apache.sling.scripting.sightly.impl.filter.XSSFilter;
import org.apache.sling.scripting.sightly.impl.plugin.AttributePlugin;
import org.apache.sling.scripting.sightly.impl.plugin.CallPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.ElementPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.IncludePlugin;
import org.apache.sling.scripting.sightly.impl.plugin.ListPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.RepeatPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.ResourcePlugin;
import org.apache.sling.scripting.sightly.impl.plugin.SetPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.TemplatePlugin;
import org.apache.sling.scripting.sightly.impl.plugin.TestPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.TextPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.UnwrapPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.UsePlugin;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={SightlyCompiler.class})
public final class SightlyCompiler {
    private final StreamTransformer optimizer;
    private final SimpleFrontend frontend;
    private final Set<String> knownExpressionOptions;
    private final List<Plugin> plugins;
    private final List<Filter> filters;

    public SightlyCompiler() {
        this(Collections.emptySet());
    }

    private SightlyCompiler(Set<String> additionalExpresionOptions) {
        ArrayList<StreamTransformer> transformers = new ArrayList<StreamTransformer>(5);
        transformers.add(ConstantFolding.transformer());
        transformers.add(DeadCodeRemoval.transformer());
        transformers.add(SyntheticMapRemoval.TRANSFORMER);
        transformers.add(UnusedVariableRemoval.TRANSFORMER);
        transformers.add(CoalescingWrites.TRANSFORMER);
        this.optimizer = new SequenceStreamTransformer(transformers);
        this.plugins = new ArrayList<Plugin>(12);
        this.plugins.add((Plugin)new AttributePlugin());
        this.plugins.add((Plugin)new CallPlugin());
        this.plugins.add((Plugin)new ElementPlugin());
        this.plugins.add((Plugin)new IncludePlugin());
        this.plugins.add((Plugin)new ListPlugin());
        this.plugins.add((Plugin)new RepeatPlugin());
        this.plugins.add((Plugin)new ResourcePlugin());
        this.plugins.add((Plugin)new TemplatePlugin());
        this.plugins.add((Plugin)new TestPlugin());
        this.plugins.add((Plugin)new SetPlugin());
        this.plugins.add((Plugin)new TextPlugin());
        this.plugins.add((Plugin)new UnwrapPlugin());
        this.plugins.add((Plugin)new UsePlugin());
        Collections.sort(this.plugins);
        this.filters = new ArrayList<Filter>(5);
        this.filters.add((Filter)I18nFilter.getInstance());
        this.filters.add((Filter)FormatFilter.getInstance());
        this.filters.add((Filter)JoinFilter.getInstance());
        this.filters.add((Filter)URIManipulationFilter.getInstance());
        this.filters.add((Filter)XSSFilter.getInstance());
        Collections.sort(this.filters);
        this.knownExpressionOptions = new HashSet<String>(additionalExpresionOptions);
        for (Filter filter : this.filters) {
            this.knownExpressionOptions.addAll(filter.getOptions());
        }
        this.knownExpressionOptions.add("context");
        for (ExpressionContext context : ExpressionContext.values()) {
            this.knownExpressionOptions.addAll(context.getOptions());
        }
        this.frontend = new SimpleFrontend(this.plugins, this.filters, this.knownExpressionOptions);
    }

    public static SightlyCompiler withKnownExpressionOptions(@NotNull Set<String> options) {
        return new SightlyCompiler(options);
    }

    public CompilationResult compile(CompilationUnit compilationUnit) {
        return this.compile(compilationUnit, null);
    }

    public CompilationResult compile(CompilationUnit compilationUnit, BackendCompiler backendCompiler) {
        String scriptName = compilationUnit.getScriptName();
        String scriptSource = null;
        PushStream stream = new PushStream();
        SanityChecker.attachChecker((CommandStream)stream);
        CommandStream optimizedStream = this.optimizer.transform((CommandStream)stream);
        CompilationResultImpl compilationResult = new CompilationResultImpl(optimizedStream);
        try {
            scriptSource = IOUtils.toString(compilationUnit.getScriptReader());
            if (backendCompiler != null) {
                backendCompiler.handle(optimizedStream);
            }
            this.frontend.compile(stream, scriptSource);
            for (PushStream.StreamMessage w : stream.getWarnings()) {
                ScriptError warning = this.getScriptError(scriptSource, w.getCode(), 1, 0, w.getMessage());
                compilationResult.getWarnings().add(new CompilerMessageImpl(scriptName, warning.errorMessage, warning.lineNumber, warning.column));
            }
        }
        catch (SightlyCompilerException e) {
            ScriptError scriptError = this.getScriptError(scriptSource, e.getOffendingInput(), e.getLine(), e.getColumn(), e.getMessage());
            compilationResult.getErrors().add(new CompilerMessageImpl(scriptName, scriptError.errorMessage, scriptError.lineNumber, scriptError.column));
        }
        catch (IOException e) {
            throw new SightlyCompilerException("Unable to read source code from CompilationUnit identifying script " + scriptName, e);
        }
        compilationResult.seal();
        return compilationResult;
    }

    private ScriptError getScriptError(String documentFragment, String offendingInput, int lineOffset, int columnOffset, String message) {
        if (StringUtils.isNotEmpty(offendingInput)) {
            String longestContiguousOffendingSequence = null;
            longestContiguousOffendingSequence = documentFragment.contains(offendingInput) ? offendingInput : this.getContiguousOffendingSequence(offendingInput);
            int offendingInputIndex = documentFragment.indexOf(longestContiguousOffendingSequence);
            if (offendingInputIndex > -1) {
                String textBeforeError = documentFragment.substring(0, offendingInputIndex);
                int line = lineOffset;
                int lastNewLineIndex = 0;
                for (String s : new String[]{"\r\n", "\r", "\n"}) {
                    int l = textBeforeError.split(s, -1).length - 1;
                    if (l + lineOffset <= line) continue;
                    line = l + lineOffset;
                    int ix = textBeforeError.lastIndexOf(s);
                    if (ix <= 0) continue;
                    lastNewLineIndex = ix + s.length() - 1;
                }
                int column = textBeforeError.substring(lastNewLineIndex).length();
                if (column != columnOffset) {
                    column += columnOffset;
                }
                return new ScriptError(line, column, longestContiguousOffendingSequence + ": " + message);
            }
        }
        return new ScriptError(lineOffset, columnOffset, message);
    }

    private String getContiguousOffendingSequence(String input) {
        if (input != null) {
            char c;
            StringBuilder longestSequence = new StringBuilder();
            char[] inputCharArray = input.toCharArray();
            for (int index = inputCharArray.length - 1; index >= 0 && !Character.isWhitespace(c = inputCharArray[index]); --index) {
                longestSequence.insert(0, c);
            }
            return longestSequence.toString();
        }
        return null;
    }

    private static class ScriptError {
        private int lineNumber;
        private int column;
        private String errorMessage;

        ScriptError(int lineNumber, int column, String errorMessage) {
            this.lineNumber = lineNumber;
            this.column = column;
            this.errorMessage = errorMessage;
        }
    }
}

