/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class SlingSafeMethodsServlet
extends GenericServlet {
    private static final long serialVersionUID = 3620512288346703072L;

    protected void doHead(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        NoBodyResponse wrappedResponse = new NoBodyResponse(response);
        this.doGet(request, wrappedResponse);
        wrappedResponse.setContentLength();
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doOptions(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Map<String, Method> methods = this.getAllDeclaredMethods(this.getClass());
        StringBuffer allowBuf = this.getAllowedRequestMethods(methods);
        response.setHeader("Allow", allowBuf.toString());
    }

    protected void doTrace(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        String CRLF = "\r\n";
        StringBuffer responseString = new StringBuffer();
        responseString.append("TRACE ").append(request.getRequestURI());
        responseString.append(' ').append(request.getProtocol());
        Enumeration<String> reqHeaderEnum = request.getHeaderNames();
        while (reqHeaderEnum.hasMoreElements()) {
            String headerName = reqHeaderEnum.nextElement();
            Enumeration<String> reqHeaderValEnum = request.getHeaders(headerName);
            while (reqHeaderValEnum.hasMoreElements()) {
                responseString.append(CRLF);
                responseString.append(headerName).append(": ");
                responseString.append((Object)reqHeaderValEnum.nextElement());
            }
        }
        responseString.append(CRLF);
        String charset = "UTF-8";
        byte[] rawResponse = responseString.toString().getBytes(charset);
        int responseLength = rawResponse.length;
        response.setContentType("message/http");
        response.setCharacterEncoding(charset);
        response.setContentLength(responseLength);
        ServletOutputStream out = response.getOutputStream();
        out.write(rawResponse);
    }

    protected void doGeneric(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleMethodNotImplemented(request, response);
    }

    protected boolean mayService(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        boolean methodKnown = true;
        String method = request.getMethod();
        if ("HEAD".equals(method)) {
            this.doHead(request, response);
        } else if ("GET".equals(method)) {
            this.doGet(request, response);
        } else if ("OPTIONS".equals(method)) {
            this.doOptions(request, response);
        } else if ("TRACE".equals(method)) {
            this.doTrace(request, response);
        } else {
            methodKnown = false;
        }
        return methodKnown;
    }

    protected void handleMethodNotImplemented(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String protocol = request.getProtocol();
        String msg = "Method " + request.getMethod() + " not supported";
        if (protocol.endsWith("1.1")) {
            response.sendError(405, msg);
        } else {
            response.sendError(400, msg);
        }
    }

    protected void service(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        boolean methodKnown = this.mayService(request, response);
        if (!methodKnown) {
            this.doGeneric(request, response);
        }
    }

    @Override
    public void service(@NotNull ServletRequest req, @NotNull ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof SlingHttpServletRequest) || !(res instanceof SlingHttpServletResponse)) {
            throw new ServletException("Not a Sling HTTP request/response");
        }
        this.service((SlingHttpServletRequest)req, (SlingHttpServletResponse)res);
    }

    @Override
    @NotNull
    public String getServletInfo() {
        return this.getClass().getSimpleName();
    }

    protected StringBuffer getAllowedRequestMethods(Map<String, Method> declaredMethods) {
        StringBuffer allowBuf = new StringBuffer();
        allowBuf.append("OPTIONS");
        allowBuf.append(", ").append("TRACE");
        if (declaredMethods.containsKey("doHead") && !declaredMethods.containsKey("doGet")) {
            allowBuf.append(", ").append("HEAD");
        } else if (declaredMethods.containsKey("doGet")) {
            allowBuf.append(", ").append("GET");
            allowBuf.append(", ").append("HEAD");
        }
        return allowBuf;
    }

    private Map<String, Method> getAllDeclaredMethods(Class<?> c) {
        Method[] declaredMethods;
        if (c == null || c.getName().equals(SlingSafeMethodsServlet.class.getName())) {
            return new HashMap<String, Method>();
        }
        Map<String, Method> methodSet = this.getAllDeclaredMethods(c.getSuperclass());
        for (Method method : declaredMethods = c.getDeclaredMethods()) {
            if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) continue;
            methodSet.put(method.getName(), method);
        }
        return methodSet;
    }

    private class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        private NoBodyOutputStream() {
        }

        int getContentLength() {
            return this.contentLength;
        }

        @Override
        public void write(int b) {
            ++this.contentLength;
        }

        @Override
        public void write(byte[] buf, int offset, int len) {
            if (len >= 0) {
                this.contentLength += len;
            } else {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
        }
    }

    private class NoBodyResponse
    extends SlingHttpServletResponseWrapper {
        private NoBodyOutputStream noBody;
        private PrintWriter writer;
        private boolean didSetContentLength;

        NoBodyResponse(SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
            this.noBody = new NoBodyOutputStream();
        }

        void setContentLength() {
            if (!this.didSetContentLength) {
                this.setContentLength(this.noBody.getContentLength());
            }
        }

        @Override
        public void setContentLength(int len) {
            super.setContentLength(len);
            this.didSetContentLength = true;
        }

        @Override
        public ServletOutputStream getOutputStream() {
            return this.noBody;
        }

        @Override
        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
                this.writer = new PrintWriter(w);
            }
            return this.writer;
        }
    }
}

