/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.NamespaceRegistryImpl;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.lock.LockStateManager;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProviderImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryImpl;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.RegistryNamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorageImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class StandaloneManagerProvider
implements ManagerProvider,
NamespaceStorage {
    @NotNull
    private final NamespaceMapping namespaceMapping = new NamespaceMapping();
    @NotNull
    private final NamespaceRegistry namespaceRegistry;
    @NotNull
    private final NamespaceResolver namespaceResolver;
    @NotNull
    private final NamePathResolver npResolver;
    @NotNull
    private final NodeTypeStorage nodeTypeStorage;
    @NotNull
    private final NodeTypeRegistryImpl nodeTypeRegistry;
    @NotNull
    private final NodeTypeManagerImpl nodeTypeManager;
    @NotNull
    private final ItemDefinitionProvider itemDefinitionProvider;

    public StandaloneManagerProvider() throws IOException, RepositoryException, ParseException {
        this(true);
    }

    public StandaloneManagerProvider(boolean registerDefaultNodeTypes) throws IOException, RepositoryException, ParseException {
        this.namespaceMapping.setMapping("", "");
        this.namespaceRegistry = new NamespaceRegistryImpl((NamespaceStorage)this);
        this.namespaceResolver = new RegistryNamespaceResolver(this.namespaceRegistry);
        this.npResolver = new DefaultNamePathResolver(this.namespaceResolver);
        this.nodeTypeStorage = new NodeTypeStorageImpl();
        this.nodeTypeRegistry = NodeTypeRegistryImpl.create((NodeTypeStorage)this.nodeTypeStorage, (NamespaceRegistry)this.namespaceRegistry);
        this.nodeTypeManager = new NodeTypeManagerImpl((NodeTypeRegistry)this.nodeTypeRegistry, (ManagerProvider)this);
        this.itemDefinitionProvider = new ItemDefinitionProviderImpl((EffectiveNodeTypeProvider)this.nodeTypeRegistry, null, null);
        if (registerDefaultNodeTypes) {
            try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/default-nodetypes.cnd"), StandardCharsets.US_ASCII);){
                this.registerNodeTypes(reader);
            }
        }
    }

    public void registerNodeTypes(Reader reader) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, ParseException, RepositoryException, IOException {
        CndImporter.registerNodeTypes(reader, null, (NodeTypeManager)this.nodeTypeManager, this.namespaceRegistry, this.getJcrValueFactory(), false);
    }

    @NotNull
    public NamePathResolver getNamePathResolver() {
        return this.npResolver;
    }

    @NotNull
    public NameResolver getNameResolver() {
        return this.getNamePathResolver();
    }

    @NotNull
    public PathResolver getPathResolver() {
        return this.getNamePathResolver();
    }

    @NotNull
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @NotNull
    public NodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public HierarchyManager getHierarchyManager() {
        throw new UnsupportedOperationException();
    }

    public AccessManager getAccessManager() {
        throw new UnsupportedOperationException();
    }

    public LockStateManager getLockStateManager() {
        throw new UnsupportedOperationException();
    }

    public VersionManager getVersionStateManager() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.itemDefinitionProvider;
    }

    @NotNull
    public NodeTypeDefinitionProvider getNodeTypeDefinitionProvider() {
        return this.nodeTypeManager;
    }

    @NotNull
    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.nodeTypeRegistry;
    }

    @NotNull
    public ValueFactory getJcrValueFactory() throws RepositoryException {
        return ValueFactoryImpl.getInstance();
    }

    @NotNull
    public QValueFactory getQValueFactory() throws RepositoryException {
        return QValueFactoryImpl.getInstance();
    }

    public AccessControlProvider getAccessControlProvider() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getRegisteredNamespaces() throws RepositoryException {
        return this.namespaceMapping.getPrefixToURIMapping();
    }

    public String getPrefix(String uri) throws RepositoryException {
        return this.namespaceMapping.getPrefix(uri);
    }

    public String getURI(String prefix) throws RepositoryException {
        return this.namespaceMapping.getURI(prefix);
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        this.namespaceMapping.setMapping(prefix, uri);
    }

    public void unregisterNamespace(String uri) throws RepositoryException {
        this.namespaceMapping.removeMapping(uri);
    }
}

