/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.version.Version;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.security.authorization.PrincipalSetPolicy;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.NodeNameList;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.DirectoryArtifact;
import org.apache.jackrabbit.vault.fs.impl.HintArtifact;
import org.apache.jackrabbit.vault.fs.impl.io.FileArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.FolderArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.GenericArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.impl.io.InputSourceArtifact;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.AutoSave;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MappedArchive;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.DefaultNodeTypeSet;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeInstaller;
import org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.accesscontrol.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.impl.ActivityLog;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Importer {
    private static final Logger log = LoggerFactory.getLogger(Importer.class);
    private static final Logger activityLog = LoggerFactory.getLogger(ActivityLog.class);
    static final String FEATURE_STASH_PRINCIPAL_POLICIES = "vault.feature.stashPrincipalPolicies";
    private WorkspaceFilter filter;
    private final Tree<PathFilterSet> filterTree = new Tree();
    private ProgressTracker tracker;
    private final DefaultNodeTypeSet nodeTypes = new DefaultNodeTypeSet("internal");
    private AutoSave autoSave = new AutoSave();
    private final Set<String> nodesToCheckin = new HashSet<String>();
    private final Map<String, String[]> memberships = new HashMap<String, String[]>();
    private Map<String, List<? extends AccessControlPolicy>> deletedPrincipalAcls = new HashMap<String, List<? extends AccessControlPolicy>>();
    private List<String> createdAuthorizableIds = new LinkedList<String>();
    private boolean hasErrors = false;
    private Exception firstException = null;
    private final FolderArtifactHandler folderHandler = new FolderArtifactHandler();
    private final GenericArtifactHandler genericHandler = new GenericArtifactHandler();
    private final FileArtifactHandler fileHandler = new FileArtifactHandler();
    private final List<Archive.Entry> patches = new LinkedList<Archive.Entry>();
    private Map<String, TxInfo> intermediates = new LinkedHashMap<String, TxInfo>();
    private Archive archive;
    private final List<String> subPackages = new LinkedList<String>();
    private final ACLManagement aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
    private final UserManagement userManagement = ServiceProviderFactory.getProvider().getUserManagement();
    private final ImportOptions opts;
    private AutoSave cpAutosave;
    private TxInfo cpTxInfo;
    private ImportInfoImpl cpImportInfo;
    private int recoveryRetryCounter;
    private final List<TxInfo> processedInfos = new ArrayList<TxInfo>();
    private Map<String, TxInfo> removedIntermediates = new LinkedHashMap<String, TxInfo>();
    private final boolean isStrict;
    private final boolean isStrictByDefault;
    private final boolean overwritePrimaryTypesOfFoldersByDefault;
    private final boolean stashPrincipalPoliciesByDefault = Boolean.getBoolean("vault.feature.stashPrincipalPolicies");
    private static final List<Character> DELIMITERS = Arrays.asList(Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('!'));

    public Importer() {
        this(new ImportOptions(), false, true);
    }

    public Importer(ImportOptions opts) {
        this(opts, false);
    }

    public Importer(ImportOptions opts, boolean isStrictByDefault) {
        this(opts, isStrictByDefault, true);
    }

    public Importer(ImportOptions opts, boolean isStrictByDefault, boolean overwritePrimaryTypesOfFoldersByDefault) {
        this(opts, isStrictByDefault, overwritePrimaryTypesOfFoldersByDefault, null);
    }

    public Importer(ImportOptions opts, boolean isStrictByDefault, boolean overwritePrimaryTypesOfFoldersByDefault, IdConflictPolicy defaultIdConflictPolicy) {
        this.opts = opts;
        this.isStrict = opts.isStrict(isStrictByDefault);
        this.isStrictByDefault = isStrictByDefault;
        this.overwritePrimaryTypesOfFoldersByDefault = overwritePrimaryTypesOfFoldersByDefault;
        if (!this.opts.hasIdConflictPolicyBeenSet() && defaultIdConflictPolicy != null) {
            this.opts.setIdConflictPolicy(defaultIdConflictPolicy);
        }
    }

    public ImportOptions getOptions() {
        return this.opts;
    }

    public List<String> getSubPackages() {
        return this.subPackages;
    }

    public boolean isStrictByDefault() {
        return this.isStrictByDefault;
    }

    public void setDebugFailAfterSave(int failAfterEach) {
        this.autoSave.setDebugFailEach(failAfterEach);
    }

    protected void track(String action, String path) {
        if ("E".equals(action)) {
            log.error("{} {}", (Object)action, (Object)path);
        } else {
            log.debug("{} {}", (Object)action, (Object)path);
        }
        activityLog.debug("{} {}", (Object)action, (Object)path);
        if (this.tracker != null) {
            this.tracker.track(action, path);
        }
    }

    protected void track(Exception e, String path) {
        log.error("E {} ({})", (Object)path, (Object)e.toString());
        if (this.tracker != null) {
            this.tracker.track(e, path);
        }
    }

    public void run(Archive archive, Node importRoot) throws IOException, RepositoryException, ConfigurationException {
        this.run(archive, importRoot.getSession(), importRoot.getPath());
    }

    public void run(Archive archive, Session session, String parentPath) throws IOException, RepositoryException, ConfigurationException {
        PathMapping pathMapping;
        this.archive = archive;
        if (this.opts.getListener() == null) {
            this.tracker = null;
        } else {
            if (this.tracker == null) {
                this.tracker = new ProgressTracker();
            }
            this.tracker.setListener(this.opts.getListener());
        }
        int version = archive.getMetaInf().getPackageFormatVersion();
        if (version > 2) {
            String msg = "Content format version not supported (" + version + " > " + 2 + ")";
            log.warn(msg);
            throw new IOException(msg);
        }
        if (this.opts.getAutoSaveThreshold() >= 0) {
            this.autoSave.setThreshold(this.opts.getAutoSaveThreshold());
        }
        this.autoSave.setDryRun(this.opts.isDryRun());
        this.autoSave.setTracker(this.tracker);
        if (this.opts.getAccessControlHandling() == null) {
            this.opts.setAccessControlHandling(AccessControlHandling.IGNORE);
        }
        this.fileHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.fileHandler.setCugHandling(this.opts.getCugHandling());
        this.genericHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.genericHandler.setCugHandling(this.opts.getCugHandling());
        this.folderHandler.setAcHandling(this.opts.getAccessControlHandling());
        this.folderHandler.setCugHandling(this.opts.getCugHandling());
        this.folderHandler.setOverwritePrimaryTypesOfFolders(this.opts.overwritePrimaryTypesOfFolders(this.overwritePrimaryTypesOfFoldersByDefault));
        this.filter = this.opts.getFilter();
        if (this.filter == null) {
            this.filter = archive.getMetaInf().getFilter();
        }
        if (this.filter == null) {
            this.filter = new DefaultWorkspaceFilter();
        }
        if ((pathMapping = this.opts.getPathMapping()) != null) {
            this.filter = this.filter.translate(pathMapping);
            this.archive = archive = new MappedArchive(archive, pathMapping);
            this.archive.open(true);
        }
        if (this.opts.getImportMode() != null) {
            if (this.filter instanceof DefaultWorkspaceFilter) {
                ((DefaultWorkspaceFilter)this.filter).setImportMode(this.opts.getImportMode());
            } else {
                log.warn("Unable to override import mode, incompatible filter: {}", (Object)this.filter.getClass().getName());
            }
        }
        for (PathFilterSet set : this.filter.getFilterSets()) {
            this.filterTree.put(set.getRoot(), set);
        }
        if ("/".equals(parentPath)) {
            parentPath = "";
        }
        this.track("Collecting import information...", "");
        TxInfo root = this.prepare(archive.getJcrRoot(), parentPath, (NamespaceResolver)new SessionNamespaceResolver(session));
        if (this.filter != null && this.filter.getFilterSets() != null && this.filter.getFilterSets().size() > 0) {
            root = this.postFilter(root);
        }
        log.debug("Access control handling set to {}", (Object)this.opts.getAccessControlHandling());
        log.debug("CUG handling set to {}", (Object)this.opts.getCugHandling());
        if (this.opts.isDryRun()) {
            this.track("Dry Run: Skipping node types installation (might lead to errors).", "");
            this.track("Simulating content import...", "");
        } else {
            this.track("Installing node types...", "");
            this.installNodeTypes(session);
            this.track("Installing privileges...", "");
            this.registerPrivileges(session);
            log.debug("Starting content import. autosave is {}", (Object)this.autoSave);
            this.track("Importing content...", "");
            if (this.tracker != null) {
                this.tracker.setMode(ProgressTrackerListener.Mode.PATHS);
            }
        }
        this.cpAutosave = this.autoSave.copy();
        LinkedList<TxInfo> skipList = new LinkedList<TxInfo>();
        while (this.recoveryRetryCounter++ < 10) {
            try {
                this.commit(session, root, skipList);
                this.autoSave.save(session, false);
                break;
            }
            catch (RepositoryException e) {
                if (this.autoSave.isDisabled() || this.recoveryRetryCounter == 10) {
                    log.error("Error while committing changes. Aborting.");
                    throw e;
                }
                log.warn("Error while committing changes: Retrying import from checkpoint at {}. Retries {}/10. {}", this.cpTxInfo == null ? "/" : this.cpTxInfo.path, this.recoveryRetryCounter, Importer.getExtendedThrowableMessage(e));
                this.autoSave = this.cpAutosave.copy();
                skipList.clear();
                TxInfo info = this.cpTxInfo;
                while (info != null && info.parent != null) {
                    skipList.addFirst(info);
                    info = info.parent;
                }
                this.intermediates.putAll(this.removedIntermediates);
                for (TxInfo i : this.removedIntermediates.values()) {
                    i.isIntermediate = (byte)1;
                }
                this.removedIntermediates.clear();
                this.processedInfos.clear();
                session.refresh(false);
            }
        }
        if (this.tracker != null) {
            this.tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        }
        this.restorePrincipalAcls(session, this.shouldStashPrincipalPoliciesForArchive(archive));
        this.checkinNodes(session);
        this.applyMemberships(session);
        this.applyPatches();
        if (this.opts.isDryRun()) {
            if (this.hasErrors) {
                this.track("Package import simulation finished. (with errors, check logs!)", "");
                log.error("There were errors during package install simulation. Please check the logs for details.");
                this.track("First error was " + Importer.getExtendedThrowableMessage(this.firstException), "");
            } else {
                this.track("Package import simulation finished.", "");
            }
        } else if (this.hasErrors) {
            this.track("Package imported (with errors, check logs!)", "");
            if (this.isStrict) {
                throw new RepositoryException("Some errors occurred while installing packages. Please check the logs for details. First exception is logged as cause.", this.firstException);
            }
            log.error("There were errors during package install. Please check the logs for details.");
            this.track("First error was " + Importer.getExtendedThrowableMessage(this.firstException), "");
        } else {
            this.track("Package imported.", "");
        }
    }

    private void restorePrincipalAcls(Session session, boolean featureStashPrincipalPolicies) throws RepositoryException {
        for (String authorizableId : this.createdAuthorizableIds) {
            String principalName = this.userManagement.getPrincipalName(session, authorizableId);
            if (!this.deletedPrincipalAcls.containsKey(principalName)) continue;
            if (this.opts.isDryRun()) {
                this.track("Dry run: Would potentially restore principal ACLs of " + principalName + " ...", "");
                continue;
            }
            if (!featureStashPrincipalPolicies) {
                this.track("vault.feature.stashPrincipalPolicies disabled: Would potentially restore principal ACLs of " + principalName + " ...", "");
                continue;
            }
            for (AccessControlPolicy accessControlPolicy : this.deletedPrincipalAcls.get(principalName)) {
                AccessControlHandling aclHandlingForRestoredPolicy;
                AccessControlHandling aclHandling = accessControlPolicy instanceof PrincipalSetPolicy ? this.opts.getCugHandling() : this.opts.getAccessControlHandling();
                switch (aclHandling) {
                    case OVERWRITE: {
                        aclHandlingForRestoredPolicy = AccessControlHandling.IGNORE;
                        break;
                    }
                    case IGNORE: {
                        aclHandlingForRestoredPolicy = AccessControlHandling.OVERWRITE;
                        break;
                    }
                    case CLEAR: {
                        aclHandlingForRestoredPolicy = AccessControlHandling.IGNORE;
                        break;
                    }
                    case MERGE: {
                        aclHandlingForRestoredPolicy = AccessControlHandling.MERGE;
                        break;
                    }
                    default: {
                        aclHandlingForRestoredPolicy = AccessControlHandling.MERGE;
                    }
                }
                String accessControlledPath = this.userManagement.getAuthorizablePath(session, authorizableId);
                List paths = JackrabbitAccessControlPolicy.fromAccessControlPolicy((AccessControlPolicy)accessControlPolicy).apply(session, aclHandlingForRestoredPolicy, accessControlledPath);
                for (String path : paths) {
                    this.track("Restored principal ACLs of " + principalName, path);
                }
            }
        }
    }

    static String getExtendedThrowableMessage(Throwable throwable) {
        StringBuilder messageBuilder = new StringBuilder();
        if (throwable == null) {
            return "";
        }
        messageBuilder.append(throwable.getClass().getName()).append(": ");
        messageBuilder.append(throwable.getMessage());
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (!Importer.isDelimiter(messageBuilder.charAt(messageBuilder.length() - 1))) {
                messageBuilder.append(".");
            }
            messageBuilder.append(" Caused by ").append(cause.getClass().getName()).append(": ").append(cause.getMessage());
        }
        return messageBuilder.toString();
    }

    static boolean isDelimiter(char character) {
        return DELIMITERS.contains(Character.valueOf(character));
    }

    private TxInfo postFilter(TxInfo root) {
        TxInfo modifierRoot = root;
        if (this.filter.contains(modifierRoot.path)) {
            return modifierRoot;
        }
        if (this.filter.isAncestor(modifierRoot.path)) {
            for (String k : modifierRoot.children().keySet()) {
                TxInfo child = modifierRoot.children().get(k);
                modifierRoot.children().put(k, this.postFilter(child));
            }
        } else {
            modifierRoot.discard();
        }
        return modifierRoot;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    protected VaultSettings getSettings() {
        return this.archive.getMetaInf().getSettings();
    }

    private void installNodeTypes(Session session) throws IOException, RepositoryException {
        Collection<NodeTypeSet> metaTypes = this.archive.getMetaInf().getNodeTypes();
        if (metaTypes != null) {
            for (NodeTypeSet cnd : metaTypes) {
                this.nodeTypes.add(cnd);
            }
        }
        if (!this.nodeTypes.getNodeTypes().isEmpty()) {
            NodeTypeInstaller installer = ServiceProviderFactory.getProvider().getDefaultNodeTypeInstaller(session);
            try {
                log.debug("Installing node types...");
                installer.install(this.tracker, this.nodeTypes);
            }
            catch (RepositoryException e) {
                if (this.isStrict) {
                    throw e;
                }
                this.track(e, "Packaged node types");
            }
        } else {
            log.debug("No node types provided.");
        }
    }

    private void registerPrivileges(Session session) throws IOException, RepositoryException {
        PrivilegeDefinitions privileges = this.archive.getMetaInf().getPrivileges();
        if (privileges != null && !privileges.getDefinitions().isEmpty()) {
            PrivilegeInstaller installer = ServiceProviderFactory.getProvider().getDefaultPrivilegeInstaller(session);
            try {
                log.debug("Registering privileges...");
                installer.install(this.tracker, privileges);
            }
            catch (RepositoryException e) {
                if (this.isStrict) {
                    throw e;
                }
                this.track(e, "Packaged privileges");
            }
        } else {
            log.debug("No privileges provided.");
        }
    }

    protected boolean isExcluded(String fileName) {
        return this.getSettings().getIgnoredNames().contains(fileName) || fileName.equals(".vlt") || fileName.startsWith(".vlt-");
    }

    private TxInfo prepare(Archive.Entry jcrRoot, String parentPath, NamespaceResolver resolver) throws IOException, RepositoryException {
        TxInfo root = new TxInfo(null, parentPath);
        Archive.Entry contentXml = jcrRoot.getChild(".content.xml");
        if (contentXml != null) {
            if (contentXml.isDirectory()) {
                throw new IllegalArgumentException(".content.xml is not a file");
            }
            root.artifacts.add((Artifact)new InputSourceArtifact(null, "", "", ArtifactType.PRIMARY, this.archive.getInputSource(contentXml), SerializationType.XML_DOCVIEW));
        }
        root.artifacts.add((Artifact)new DirectoryArtifact(Text.getName(parentPath)));
        this.prepare(jcrRoot, root, resolver);
        for (PathFilterSet sets : this.filter.getFilterSets()) {
            String rootPath = sets.getRoot();
            if (parentPath.length() > 0 && rootPath.startsWith(parentPath)) {
                rootPath = rootPath.substring(parentPath.length());
            }
            String[] segments = Text.explode(rootPath, 47);
            TxInfo current = root;
            StringBuilder path = new StringBuilder();
            for (String name : segments) {
                path.append('/').append(name);
                TxInfo child = current.children().get(name);
                if (child == null) {
                    log.trace("Creating missing intermediate directory artifact for {}", (Object)name);
                    child = current.addChild(new TxInfo(current, path.toString()));
                    child.isIntermediate = (byte)1;
                    this.intermediates.put(path.toString(), child);
                }
                current = child;
            }
        }
        return root;
    }

    private void prepare(Archive.Entry directory, TxInfo parentInfo, NamespaceResolver resolver) throws IOException, RepositoryException {
        String repoPath;
        String repoName;
        String fileName;
        Collection<? extends Archive.Entry> files = directory.getChildren();
        for (Archive.Entry entry : files) {
            if (!entry.isDirectory() || this.isExcluded(fileName = entry.getName())) continue;
            repoName = PlatformNameFormat.getRepositoryName(fileName);
            repoPath = parentInfo.path + "/" + repoName;
            if (repoName.endsWith(".dir")) {
                repoName = repoName.substring(0, repoName.length() - 4);
                repoPath = parentInfo.path + "/" + repoName;
            }
            TxInfo info = parentInfo.addChild(new TxInfo(parentInfo, repoPath));
            log.trace("Creating directory artifact for {}", (Object)repoName);
            DirectoryArtifact parent = new DirectoryArtifact(repoName);
            info.artifacts.add((Artifact)parent);
            Archive.Entry contentXml = entry.getChild(".content.xml");
            if (contentXml != null) {
                if (contentXml.isDirectory()) {
                    throw new IllegalArgumentException(".content.xml is not a file");
                }
                info.artifacts.add((Artifact)new InputSourceArtifact((Artifact)parent, ".content.xml", "", ArtifactType.PRIMARY, this.archive.getInputSource(contentXml), SerializationType.XML_DOCVIEW));
            } else {
                info.isIntermediate = (byte)1;
                this.intermediates.put(repoPath, info);
                log.trace("Detecting intermediate directory {}", (Object)repoName);
            }
            this.prepare(entry, info, resolver);
        }
        for (Archive.Entry entry : files) {
            if (entry.isDirectory() || this.isExcluded(fileName = entry.getName())) continue;
            repoName = PlatformNameFormat.getRepositoryName(fileName);
            repoPath = parentInfo.path + "/" + repoName;
            if (entry.getName().equals(".content.xml")) continue;
            if (this.opts.getPatchDirectory() != null && repoPath.startsWith(this.opts.getPatchParentPath())) {
                this.patches.add(entry);
                if (!this.opts.isPatchKeepInRepo()) continue;
            }
            if (repoPath.startsWith("/etc/packages/") && (repoPath.endsWith(".jar") || repoPath.endsWith(".zip"))) {
                this.subPackages.add(repoPath);
            }
            String repoBase = repoName;
            String ext = "";
            int idx = repoName.lastIndexOf(46);
            if (idx > 0) {
                repoBase = repoName.substring(0, idx);
                ext = repoName.substring(idx);
            }
            SerializationType serType = SerializationType.GENERIC;
            ArtifactType type = ArtifactType.PRIMARY;
            VaultInputSource is = this.archive.getInputSource(entry);
            if (".xml".equals(ext)) {
                if (DocViewParser.isDocView(is)) {
                    repoName = repoBase;
                    serType = SerializationType.XML_DOCVIEW;
                } else {
                    ext = "";
                    serType = SerializationType.GENERIC;
                    type = ArtifactType.FILE;
                }
            } else if (".cnd".equals(ext)) {
                if (this.opts.getCndPattern().matcher(repoPath).matches()) {
                    InputStream in = is.getByteStream();
                    try (InputStreamReader r = new InputStreamReader(in, "utf8");){
                        CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                        reader.read(r, is.getSystemId(), new NamespaceMapping(resolver));
                        this.nodeTypes.add(reader);
                        log.debug("Loaded nodetypes from {}.", (Object)repoPath);
                    }
                    catch (IOException e1) {
                        log.error("Error while reading CND.", e1);
                    }
                }
                ext = "";
                type = ArtifactType.FILE;
            } else if (".binary".equals(ext)) {
                serType = SerializationType.GENERIC;
                type = ArtifactType.BINARY;
                repoName = repoBase;
            } else {
                ext = "";
                type = ArtifactType.FILE;
            }
            if (type != ArtifactType.PRIMARY) {
                TxInfo parent = parentInfo.children().get(repoName);
                if (parent == null) {
                    if (type == ArtifactType.BINARY) {
                        parent = parentInfo;
                        while (parent != null && parent.isIntermediate > 0) {
                            parent = parent.parent;
                        }
                        if (parent == null) {
                            log.warn("No parent info found {}. using direct.");
                            parent = parentInfo;
                        }
                    } else {
                        TxInfo tx = new TxInfo(parentInfo, parentInfo.path + "/" + repoName);
                        log.trace("Creating file artifact for {}", (Object)repoName);
                        tx.artifacts.add((Artifact)new InputSourceArtifact(null, repoName, ext, type, is, serType));
                        parentInfo.addChild(tx);
                    }
                }
                if (parent != null) {
                    String path = parentInfo.path + "/" + repoName;
                    String relPath = parent.name + path.substring(parent.path.length());
                    log.trace("Attaching {} artifact {}", (Object)type, (Object)path);
                    parent.artifacts.add((Artifact)new InputSourceArtifact(null, relPath, ext, type, is, serType));
                }
            }
            if (type != ArtifactType.PRIMARY) continue;
            TxInfo tx = new TxInfo(parentInfo, parentInfo.path + "/" + repoName);
            log.trace("Creating primary artifact for {}", (Object)repoName);
            tx.artifacts.add((Artifact)new InputSourceArtifact(null, repoName, ext, type, is, serType));
            parentInfo.addChild(tx);
        }
        Tree.Node<PathFilterSet> filterNode = this.filterTree.getNode(parentInfo.path);
        if (filterNode != null) {
            parentInfo.sort(filterNode.getChildren().keySet());
        }
    }

    private void commit(Session session, TxInfo info, LinkedList<TxInfo> skipList) throws RepositoryException, IOException {
        try {
            ImportInfoImpl imp = null;
            if (skipList.isEmpty()) {
                if (info == this.cpTxInfo) {
                    log.trace("skipping last checkpoint info {}", (Object)info.path);
                    imp = this.cpImportInfo;
                } else {
                    imp = this.commit(session, info);
                    if (imp != null) {
                        this.nodesToCheckin.addAll(imp.getToVersion());
                        this.memberships.putAll(imp.getMemberships());
                        this.autoSave.modified(imp.numModified());
                        this.deletedPrincipalAcls.putAll(imp.getDeletedPrincipalAcls());
                        this.createdAuthorizableIds.addAll(imp.getCreatedAuthorizableIds());
                    }
                }
            } else if (log.isDebugEnabled()) {
                StringBuilder skips = new StringBuilder();
                for (TxInfo txInfo : skipList) {
                    skips.append(txInfo.path).append(',');
                }
                log.trace("skip list: {}", (Object)skips);
            }
            if (this.autoSave.needsSave()) {
                this.autoSave.save(session, true);
                this.cpTxInfo = info;
                this.cpAutosave = this.autoSave.copy();
                this.cpImportInfo = imp;
                this.recoveryRetryCounter = 0;
                this.removedIntermediates.clear();
                this.processedInfos.clear();
            }
            ArrayList<TxInfo> children = new ArrayList<TxInfo>(info.children().values());
            TxInfo next = skipList.isEmpty() ? null : skipList.removeFirst();
            for (TxInfo child : children) {
                if (next == null || next == child) {
                    this.commit(session, child, skipList);
                    next = null;
                    continue;
                }
                log.trace("skipping {}", (Object)child.path);
            }
            if (info.nameList != null) {
                Node node = info.getNode(session);
                if (node == null) {
                    log.warn("Unable to restore order of {}. Node does not exist.", (Object)info.path);
                } else if (info.nameList.needsReorder(node)) {
                    log.trace("Restoring order of {}.", (Object)info.path);
                    info.nameList.restoreOrder(node);
                }
            }
            this.processedInfos.add(info);
        }
        catch (RepositoryException e) {
            log.error("Error while committing {}: {}", (Object)info.path, (Object)e.toString());
            throw e;
        }
    }

    private ImportInfoImpl commit(Session session, TxInfo info) throws RepositoryException, IOException {
        Node node;
        log.trace("committing {}", (Object)info.path);
        ImportInfoImpl imp = null;
        if (info.artifacts == null) {
            log.debug("S {}", (Object)info.path);
        } else if (info.artifacts.isEmpty()) {
            if (this.filter.contains(info.path) && session.nodeExists(info.path) && info.isIntermediate < 2) {
                node = session.getNode(info.path);
                imp = new ImportInfoImpl();
                if (this.aclManagement.isACLNode(node)) {
                    if (this.opts.getAccessControlHandling() == AccessControlHandling.OVERWRITE || this.opts.getAccessControlHandling() == AccessControlHandling.CLEAR) {
                        imp.onDeleted(info.path);
                        this.aclManagement.clearACL(node.getParent());
                    }
                } else if (this.filter.getImportMode(info.path) == ImportMode.REPLACE) {
                    imp.onDeleted(info.path);
                    node.remove();
                } else {
                    imp.onNop(info.path);
                }
            }
        } else if (info.artifacts.getPrimaryData() != null && info.artifacts.size() == 1) {
            node = info.getParentNode(session);
            if (node == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, (Exception)new IllegalStateException("Parent node not found."));
            } else {
                imp = this.genericHandler.accept(this.opts, this.isStrictByDefault, this.filter, node, info.artifacts.getPrimaryData().getRelativePath(), info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("generic handler did not accept " + info.path);
                }
            }
        } else if (info.artifacts.getDirectory() != null) {
            String prefix = info.parent == null ? info.name : info.name + "/";
            for (TxInfo child : info.children().values()) {
                if (child.artifacts == null) {
                    String path = prefix + child.name;
                    info.artifacts.add((Artifact)new HintArtifact(path));
                    continue;
                }
                for (Artifact a : child.artifacts.values()) {
                    String path = prefix + a.getRelativePath();
                    info.artifacts.add((Artifact)new HintArtifact(path));
                }
            }
            Node node2 = info.getParentNode(session);
            if (node2 == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, (Exception)new IllegalStateException("Parent node not found."));
            } else if (info.isIntermediate == 2) {
                log.trace("skipping intermediate node at {}", (Object)info.path);
            } else if (info.artifacts.getPrimaryData() == null) {
                imp = this.folderHandler.accept(this.opts, this.isStrictByDefault, this.filter, node2, info.name, info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("folder handler did not accept " + info.path);
                }
            } else {
                imp = this.genericHandler.accept(this.opts, this.isStrictByDefault, this.filter, node2, info.artifacts.getDirectory().getRelativePath(), info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("generic handler did not accept " + info.path);
                }
            }
        } else if (info.artifacts.size(ArtifactType.FILE) > 0) {
            node = info.getParentNode(session);
            if (node == null) {
                imp = new ImportInfoImpl();
                imp.onError(info.path, (Exception)new IllegalStateException("Parent node not found."));
            } else {
                imp = this.fileHandler.accept(this.opts, this.isStrictByDefault, this.filter, node, info.name, info.artifacts);
                if (imp == null) {
                    throw new IllegalStateException("file handler did not accept " + info.path);
                }
            }
        } else {
            throw new UnsupportedOperationException("ArtifactSet not supported: " + info.artifacts);
        }
        if (imp != null) {
            for (Map.Entry entry : imp.getInfos().entrySet()) {
                TxInfo subInfo;
                NodeNameList nameList;
                TxInfo im;
                String path = (String)entry.getKey();
                ImportInfo.Type type = ((ImportInfo.Info)entry.getValue()).getType();
                if (type != ImportInfo.Type.DEL && (im = this.intermediates.remove(path)) != null) {
                    log.debug("P {}", (Object)path);
                    this.removedIntermediates.put(path, im);
                    im.isIntermediate = (byte)2;
                }
                switch (type) {
                    case CRE: {
                        this.track("A", path);
                        break;
                    }
                    case DEL: {
                        this.track("D", path);
                        break;
                    }
                    case MOD: {
                        this.track("U", path);
                        break;
                    }
                    case NOP: {
                        this.track("-", path);
                        break;
                    }
                    case REP: {
                        this.track("R", path);
                        break;
                    }
                    case MIS: {
                        this.track("!", path);
                        break;
                    }
                    case ERR: {
                        Exception error = ((ImportInfo.Info)entry.getValue()).getError();
                        if (error == null) {
                            this.track("E", path);
                        } else {
                            this.track(error, path);
                        }
                        this.hasErrors = true;
                        if (this.firstException != null) break;
                        this.firstException = new PackageException("Error creating/updating node " + path, error);
                    }
                }
                if ((nameList = ((ImportInfo.Info)entry.getValue()).getNameList()) == null || !this.filter.contains(path) && type != ImportInfo.Type.CRE || (subInfo = info.findChild(path)) == null) continue;
                subInfo.nameList = nameList;
            }
            info = info.remap(imp.getRemapped());
        }
        log.trace("committed {}", (Object)info.path);
        return imp;
    }

    public void checkinNodes(Session session) {
        if (this.nodesToCheckin.isEmpty()) {
            return;
        }
        if (this.opts.isDryRun()) {
            this.track("Dry run: Would commit versions...", "");
        } else {
            this.track("Committing versions...", "");
        }
        for (String path : this.nodesToCheckin) {
            try {
                Node node = session.getNode(path);
                try {
                    if (this.opts.isDryRun()) {
                        this.track("V", String.format("%s (---)", path));
                        continue;
                    }
                    Version v = node.checkin();
                    this.track("V", String.format("%s (%s)", path, v.getName()));
                }
                catch (RepositoryException e) {
                    log.error("Error while checkin node {}: {}", (Object)path, (Object)e.toString());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving node to be versioned at {}.", (Object)path, (Object)e);
            }
        }
        this.nodesToCheckin.clear();
    }

    public void applyMemberships(Session session) {
        if (this.memberships.isEmpty()) {
            return;
        }
        if (this.opts.isDryRun()) {
            this.track("Dry run: Would apply merged group memberships...", "");
        } else {
            this.track("Applying merged group memberships...", "");
        }
        for (String id : this.memberships.keySet()) {
            String[] members = this.memberships.get(id);
            String authPath = this.userManagement.getAuthorizablePath(session, id);
            if (authPath == null) continue;
            if (!this.opts.isDryRun()) {
                this.userManagement.addMembers(session, id, members);
            }
            this.track("U", String.format("%s", authPath));
        }
        if (!this.autoSave.isDisabled()) {
            try {
                session.save();
            }
            catch (RepositoryException e) {
                log.error("Error while updating memberships.", e);
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        this.memberships.clear();
    }

    private void applyPatches() {
        for (Archive.Entry e : this.patches) {
            String name = e.getName();
            File target = new File(this.opts.getPatchDirectory(), name);
            if (this.opts.isDryRun()) {
                log.debug("Dry run: Would copy patch {} to {}", (Object)name, (Object)target.getPath());
            } else {
                log.debug("Copying patch {} to {}", (Object)name, (Object)target.getPath());
                try (InputStream in = this.archive.getInputSource(e).getByteStream();
                     FileOutputStream out = FileUtils.openOutputStream(target);){
                    IOUtils.copy(in, (OutputStream)out);
                }
                catch (IOException e1) {
                    log.error("Error while copying patch.", (Object)e);
                }
            }
            this.track("P", name);
        }
    }

    boolean shouldStashPrincipalPoliciesForArchive(Archive archive) {
        return Optional.ofNullable(archive.getMetaInf().getProperties()).filter(properties -> properties.containsKey(FEATURE_STASH_PRINCIPAL_POLICIES)).map(properties -> Boolean.valueOf(properties.getProperty(FEATURE_STASH_PRINCIPAL_POLICIES))).orElse(this.stashPrincipalPoliciesByDefault);
    }

    private static class TxInfo {
        private TxInfo parent;
        private final String path;
        private final String name;
        private ArtifactSetImpl artifacts = new ArtifactSetImpl();
        private Map<String, TxInfo> children;
        private byte isIntermediate = 0;
        private NodeNameList nameList;

        public TxInfo(TxInfo parent, String path) {
            log.trace("New TxInfo {}", (Object)path);
            this.parent = parent;
            this.path = path;
            this.name = Text.getName(path);
        }

        public TxInfo addChild(TxInfo child) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, TxInfo>();
            }
            this.children.put(child.name, child);
            return child;
        }

        public Map<String, TxInfo> children() {
            if (this.children == null) {
                return Collections.emptyMap();
            }
            return this.children;
        }

        public void sort(Collection<String> names) {
            if (this.children == null || this.children.size() <= 1 || names == null || names.isEmpty()) {
                return;
            }
            LinkedHashMap<String, TxInfo> ret = new LinkedHashMap<String, TxInfo>();
            Iterator<String> iter = names.iterator();
            while (iter.hasNext() && this.children.size() > 1) {
                String name = iter.next();
                TxInfo info = this.children.remove(name);
                if (info == null) continue;
                ret.put(name, info);
            }
            ret.putAll(this.children);
            this.children = ret;
        }

        public Node getParentNode(Session s) throws RepositoryException {
            String parentPath = TxInfo.emptyPathToRoot(Text.getRelativeParent(this.path, 1));
            return s.nodeExists(parentPath) ? s.getNode(parentPath) : null;
        }

        public Node getNode(Session s) throws RepositoryException {
            String p = TxInfo.emptyPathToRoot(this.path);
            return s.nodeExists(p) ? s.getNode(p) : null;
        }

        public void discard() {
            log.trace("discarding {}", (Object)this.path);
            this.artifacts = null;
            this.children = null;
        }

        public TxInfo findChild(String absPath) {
            if (this.path.equals(absPath)) {
                return this;
            }
            if (!absPath.startsWith(this.path + "/")) {
                return null;
            }
            absPath = absPath.substring(this.path.length());
            TxInfo root = this;
            for (String name : Text.explode(absPath, 47)) {
                if ((root = root.children().get(name)) == null) break;
            }
            return root;
        }

        public TxInfo remap(PathMapping mapping) {
            String mappedPath = mapping.map(this.path, true);
            if (mappedPath.equals(this.path)) {
                return this;
            }
            TxInfo ret = new TxInfo(this.parent, mappedPath);
            ret.artifacts.addAll((ArtifactSet)this.artifacts);
            ret.nameList = this.nameList;
            ret.isIntermediate = this.isIntermediate;
            if (this.children != null) {
                for (TxInfo child : this.children.values()) {
                    child = child.remap(mapping);
                    child.parent = this;
                    ret.addChild(child);
                }
            }
            if (this.parent.children != null) {
                this.parent.children.put(ret.name, ret);
            }
            return ret;
        }

        private static String emptyPathToRoot(String path) {
            return path == null || path.length() == 0 ? "/" : path;
        }
    }
}

