/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.basic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipConfig;
import org.jetbrains.annotations.NotNull;

public class DefaultSyncConfig {
    public static final String DEFAULT_NAME = "default";
    private final User user = new User();
    private final Group group = new Group();
    private String name = "default";

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public DefaultSyncConfig setName(@NotNull String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public User user() {
        return this.user;
    }

    @NotNull
    public Group group() {
        return this.group;
    }

    public static class Group
    extends Authorizable {
        private boolean dynamicGroups;

        public boolean getDynamicGroups() {
            return this.dynamicGroups;
        }

        @NotNull
        public Group setDynamicGroups(boolean dynamicGroups) {
            this.dynamicGroups = dynamicGroups;
            return this;
        }
    }

    public static class User
    extends Authorizable {
        private long membershipExpirationTime;
        private long membershipNestingDepth;
        private boolean dynamicMembership;
        private boolean enforceDynamicMembership;
        private boolean disableMissing;

        public long getMembershipExpirationTime() {
            return this.membershipExpirationTime;
        }

        @NotNull
        public User setMembershipExpirationTime(long membershipExpirationTime) {
            this.membershipExpirationTime = membershipExpirationTime;
            return this;
        }

        public long getMembershipNestingDepth() {
            return this.membershipNestingDepth;
        }

        @NotNull
        public User setMembershipNestingDepth(long membershipNestingDepth) {
            this.membershipNestingDepth = membershipNestingDepth;
            return this;
        }

        public boolean getDynamicMembership() {
            return this.dynamicMembership;
        }

        @NotNull
        public User setDynamicMembership(boolean dynamicMembership) {
            this.dynamicMembership = dynamicMembership;
            return this;
        }

        public boolean getEnforceDynamicMembership() {
            return this.enforceDynamicMembership;
        }

        public User setEnforceDynamicMembership(boolean enforceDynamicMembership) {
            this.enforceDynamicMembership = enforceDynamicMembership;
            return this;
        }

        public boolean getDisableMissing() {
            return this.disableMissing;
        }

        public User setDisableMissing(boolean disableMissing) {
            this.disableMissing = disableMissing;
            return this;
        }
    }

    public static abstract class Authorizable {
        private long expirationTime;
        private Set<String> autoMembership;
        private Map<String, String> propertyMapping;
        private String pathPrefix;
        private boolean applyRFC7613UsernameCaseMapped;
        private AutoMembershipConfig autoMembershipConfig = AutoMembershipConfig.EMPTY;

        public long getExpirationTime() {
            return this.expirationTime;
        }

        @NotNull
        public Authorizable setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public boolean isApplyRFC7613UsernameCaseMapped() {
            return this.applyRFC7613UsernameCaseMapped;
        }

        public Authorizable setApplyRFC7613UsernameCaseMapped(boolean applyRFC7613UsernameCaseMapped) {
            this.applyRFC7613UsernameCaseMapped = applyRFC7613UsernameCaseMapped;
            return this;
        }

        @NotNull
        public Set<String> getAutoMembership() {
            return this.autoMembership == null ? Collections.emptySet() : this.autoMembership;
        }

        @NotNull
        public Authorizable setAutoMembership(String ... autoMembership) {
            this.autoMembership = new HashSet<String>();
            for (String groupName : autoMembership) {
                if (groupName == null || groupName.trim().isEmpty()) continue;
                this.autoMembership.add(groupName.trim());
            }
            return this;
        }

        @NotNull
        public AutoMembershipConfig getAutoMembershipConfig() {
            return this.autoMembershipConfig;
        }

        @NotNull
        public Authorizable setAutoMembershipConfig(@NotNull AutoMembershipConfig autoMembershipConfig) {
            this.autoMembershipConfig = autoMembershipConfig;
            return this;
        }

        @NotNull
        public Set<String> getAutoMembership(@NotNull org.apache.jackrabbit.api.security.user.Authorizable authorizable) {
            return ImmutableSet.builder().addAll(this.autoMembershipConfig.getAutoMembership(authorizable)).addAll(this.getAutoMembership()).build();
        }

        @NotNull
        public Map<String, String> getPropertyMapping() {
            return this.propertyMapping == null ? Collections.emptyMap() : this.propertyMapping;
        }

        @NotNull
        public Authorizable setPropertyMapping(@NotNull Map<String, String> propertyMapping) {
            this.propertyMapping = propertyMapping;
            return this;
        }

        @NotNull
        public String getPathPrefix() {
            return this.pathPrefix == null ? "" : this.pathPrefix;
        }

        @NotNull
        public Authorizable setPathPrefix(@NotNull String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }
    }
}

