/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.api.binary.BinaryDownload;
import org.apache.jackrabbit.api.binary.BinaryDownloadOptions;
import org.apache.jackrabbit.guava.common.base.MoreObjects;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BinaryImpl
implements ReferenceBinary,
BinaryDownload {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryImpl.class);
    private final ValueImpl value;

    BinaryImpl(ValueImpl value) {
        this.value = value;
    }

    ValueImpl getBinaryValue() {
        return this.value.getType() == 2 ? this.value : null;
    }

    @Override
    public InputStream getStream() throws RepositoryException {
        return this.value.getBlob().getNewStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, long position) throws IOException, RepositoryException {
        try (InputStream stream = this.getStream();){
            if (position != stream.skip(position)) {
                throw new IOException("Can't skip to position " + position);
            }
            int n = stream.read(b);
            return n;
        }
    }

    @Override
    public long getSize() throws RepositoryException {
        switch (this.value.getType()) {
            case 7: 
            case 8: {
                return this.value.getString().length();
            }
        }
        return this.value.getBlob().length();
    }

    @Override
    public void dispose() {
    }

    @Override
    @Nullable
    public URI getURI(@NotNull BinaryDownloadOptions downloadOptions) throws RepositoryException {
        ValueImpl v = this.getBinaryValue();
        if (v == null || v.getBlob().isInlined()) {
            return null;
        }
        Blob blob = v.getBlob();
        String blobId = blob.getContentIdentity();
        if (null != blobId) {
            return v.getDownloadURI(blob, downloadOptions);
        }
        return null;
    }

    @Override
    @Nullable
    public String getReference() {
        try {
            return this.value.getBlob().getReference();
        }
        catch (RepositoryException e) {
            LOG.warn("Error getting binary reference", e);
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ReferenceBinary) {
            return Objects.equals(this.getReference(), ((ReferenceBinary)other).getReference());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.value).toString();
    }
}

