/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.io.ByteStreams;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryNodeStore
implements NodeStore,
Observable {
    private final AtomicReference<NodeState> root;
    private final Map<String, Checkpoint> checkpoints = new HashMap<String, Checkpoint>();
    private final Map<Closeable, Observer> observers = new HashMap<Closeable, Observer>();
    private final AtomicInteger checkpointCounter = new AtomicInteger();

    public MemoryNodeStore(NodeState state) {
        this.root = new AtomicReference<MemoryNodeState>(MemoryNodeState.wrap(state));
    }

    public MemoryNodeStore() {
        this(EmptyNodeState.EMPTY_NODE);
    }

    public String toString() {
        return this.getRoot().toString();
    }

    @Override
    public synchronized Closeable addObserver(Observer observer) {
        observer.contentChanged(this.getRoot(), CommitInfo.EMPTY_EXTERNAL);
        Closeable closeable = new Closeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                MemoryNodeStore memoryNodeStore = MemoryNodeStore.this;
                synchronized (memoryNodeStore) {
                    MemoryNodeStore.this.observers.remove(this);
                }
            }
        };
        this.observers.put(closeable, observer);
        return closeable;
    }

    private synchronized void setRoot(NodeState root, CommitInfo info) {
        this.root.getAndSet(root);
        for (Observer observer : this.observers.values()) {
            observer.contentChanged(root, info);
        }
    }

    @Override
    public NodeState getRoot() {
        return this.root.get();
    }

    @Override
    public synchronized NodeState merge(@NotNull NodeBuilder builder, @NotNull CommitHook commitHook, @NotNull CommitInfo info) throws CommitFailedException {
        Validate.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        MemoryNodeBuilder mnb = (MemoryNodeBuilder)builder;
        Validate.checkArgument((boolean)mnb.isRoot());
        Objects.requireNonNull(commitHook);
        this.rebase(builder);
        MemoryNodeStoreBranch branch = new MemoryNodeStoreBranch(this, this.getRoot());
        branch.setRoot(builder.getNodeState());
        NodeState merged = branch.merge(commitHook, info);
        mnb.reset(merged);
        return merged;
    }

    @Override
    public NodeState rebase(@NotNull NodeBuilder builder) {
        Validate.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        NodeState head = Objects.requireNonNull(builder).getNodeState();
        NodeState base = builder.getBaseState();
        NodeState newBase = this.getRoot();
        if (base != newBase) {
            ((MemoryNodeBuilder)builder).reset(newBase);
            head.compareAgainstBaseState(base, new ConflictAnnotatingRebaseDiff(builder));
            head = builder.getNodeState();
        }
        return head;
    }

    @Override
    public NodeState reset(@NotNull NodeBuilder builder) {
        Validate.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        NodeState head = this.getRoot();
        ((MemoryNodeBuilder)builder).reset(head);
        return head;
    }

    @Override
    public ArrayBasedBlob createBlob(InputStream inputStream) throws IOException {
        try {
            ArrayBasedBlob arrayBasedBlob = new ArrayBasedBlob(ByteStreams.toByteArray((InputStream)inputStream));
            return arrayBasedBlob;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public Blob getBlob(@NotNull String reference) {
        return null;
    }

    @Override
    @NotNull
    public String checkpoint(long lifetime, @NotNull Map<String, String> properties) {
        Validate.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        Objects.requireNonNull(properties);
        String checkpoint = "checkpoint" + this.checkpointCounter.incrementAndGet();
        this.checkpoints.put(checkpoint, new Checkpoint(this.getRoot(), properties));
        return checkpoint;
    }

    @Override
    @NotNull
    public synchronized String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @Override
    @NotNull
    public Map<String, String> checkpointInfo(@NotNull String checkpoint) {
        Checkpoint cp = this.checkpoints.get(Objects.requireNonNull(checkpoint));
        if (cp == null) {
            return Collections.emptyMap();
        }
        return cp.getProperties();
    }

    @Override
    @NotNull
    public synchronized Iterable<String> checkpoints() {
        return new ArrayList<String>(this.checkpoints.keySet());
    }

    @Override
    @Nullable
    public synchronized NodeState retrieve(@NotNull String checkpoint) {
        Checkpoint cp = this.checkpoints.get(Objects.requireNonNull(checkpoint));
        if (cp == null) {
            return null;
        }
        return cp.getRoot();
    }

    @Override
    public synchronized boolean release(String checkpoint) {
        this.checkpoints.remove(checkpoint);
        return true;
    }

    public Set<String> listCheckpoints() {
        return CollectionUtils.toSet(this.checkpoints());
    }

    private static class Checkpoint {
        private final NodeState root;
        private final Map<String, String> properties;

        private Checkpoint(NodeState root, Map<String, String> properties) {
            this.root = root;
            this.properties = Maps.newHashMap(properties);
        }

        public NodeState getRoot() {
            return this.root;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    private static class MemoryNodeStoreBranch
    implements NodeStoreBranch {
        private final MemoryNodeStore store;
        private final NodeState base;
        private volatile NodeState root;

        public MemoryNodeStoreBranch(MemoryNodeStore store, NodeState base) {
            this.store = store;
            this.base = base;
            this.root = base;
        }

        @Override
        public NodeState getBase() {
            return this.base;
        }

        @Override
        public NodeState getHead() {
            this.checkNotMerged();
            return this.root;
        }

        @Override
        public void setRoot(NodeState newRoot) {
            this.checkNotMerged();
            this.root = ModifiedNodeState.squeeze(newRoot);
        }

        @Override
        public NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info) throws CommitFailedException {
            Objects.requireNonNull(hook);
            Objects.requireNonNull(info);
            this.checkNotMerged();
            NodeState merged = ModifiedNodeState.squeeze(hook.processCommit(this.base, this.root, info));
            this.store.setRoot(merged, info);
            this.root = null;
            return merged;
        }

        @Override
        public void rebase() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.root.toString();
        }

        private void checkNotMerged() {
            Validate.checkState((this.root != null ? 1 : 0) != 0, (Object)"Branch has already been merged");
        }
    }
}

