/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class GenericPropertyState
extends SinglePropertyState<String> {
    private final String value;
    private final Type<?> type;

    public GenericPropertyState(@NotNull String name, @NotNull String value, @NotNull Type<?> type) {
        super(name);
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
        Validate.checkArgument((!type.isArray() ? 1 : 0) != 0);
    }

    public static PropertyState dateProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.DATE);
    }

    public static PropertyState nameProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.NAME);
    }

    public static PropertyState pathProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.PATH);
    }

    public static PropertyState referenceProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.REFERENCE);
    }

    public static PropertyState weakreferenceProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.WEAKREFERENCE);
    }

    public static PropertyState uriProperty(String name, String value) {
        return new GenericPropertyState(name, value, Type.URI);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value, this.type);
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }
}

