/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SecureSortedSetDocValuesFacetCounts;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.TapeSampling;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatisticalSortedSetDocValuesFacetCounts
extends SortedSetDocValuesFacetCounts {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticalSortedSetDocValuesFacetCounts.class);
    private final FacetsCollector facetsCollector;
    private final Filter filter;
    private final IndexReader reader;
    private final IndexDefinition.SecureFacetConfiguration secureFacetConfiguration;
    private final DefaultSortedSetDocValuesReaderState state;
    private FacetResult facetResult = null;

    StatisticalSortedSetDocValuesFacetCounts(DefaultSortedSetDocValuesReaderState state, FacetsCollector facetsCollector, Filter filter, IndexDefinition.SecureFacetConfiguration secureFacetConfiguration) throws IOException {
        super(state, facetsCollector);
        this.state = state;
        this.reader = state.origReader;
        this.facetsCollector = facetsCollector;
        this.filter = filter;
        this.secureFacetConfiguration = secureFacetConfiguration;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (this.facetResult == null) {
            this.facetResult = this.getTopChildren0(topN, dim, path);
        }
        return this.facetResult;
    }

    private FacetResult getTopChildren0(int topN, String dim, String ... path) throws IOException {
        Iterator<Integer> docIterator;
        FacetResult topChildren = super.getTopChildren(topN, dim, path);
        if (topChildren == null) {
            return null;
        }
        LabelAndValue[] labelAndValues = topChildren.labelValues;
        List<FacetsCollector.MatchingDocs> matchingDocsList = this.facetsCollector.getMatchingDocs();
        int hitCount = 0;
        for (FacetsCollector.MatchingDocs matchingDocs : matchingDocsList) {
            hitCount += matchingDocs.totalHits;
        }
        int sampleSize = this.secureFacetConfiguration.getStatisticalFacetSampleSize();
        if (hitCount < sampleSize) {
            return new SecureSortedSetDocValuesFacetCounts(this.state, this.facetsCollector, this.filter).getTopChildren(topN, dim, path);
        }
        long randomSeed = this.secureFacetConfiguration.getRandomSeed();
        LOG.debug("Sampling facet dim {}; hitCount: {}, sampleSize: {}, seed: {}", dim, hitCount, sampleSize, randomSeed);
        Stopwatch w = Stopwatch.createStarted();
        Iterator<Integer> sampleIterator = docIterator = this.getMatchingDocIterator(matchingDocsList);
        if (sampleSize < hitCount) {
            sampleIterator = this.getSampledMatchingDocIterator(docIterator, randomSeed, hitCount, sampleSize);
        } else {
            sampleSize = hitCount;
        }
        int accessibleSampleCount = this.getAccessibleSampleCount(dim, sampleIterator);
        w.stop();
        LOG.debug("Evaluated accessible samples {} in {}", (Object)accessibleSampleCount, (Object)w);
        labelAndValues = this.updateLabelAndValueIfRequired(labelAndValues, sampleSize, accessibleSampleCount);
        int childCount = labelAndValues.length;
        Number value = 0;
        for (LabelAndValue lv : labelAndValues) {
            value = ((Number)value).longValue() + lv.value.longValue();
        }
        return new FacetResult(dim, path, value, labelAndValues, childCount);
    }

    private Iterator<Integer> getMatchingDocIterator(List<FacetsCollector.MatchingDocs> matchingDocsList) {
        final Iterator<FacetsCollector.MatchingDocs> matchingDocsListIterator = matchingDocsList.iterator();
        return new AbstractIterator<Integer>(){
            FacetsCollector.MatchingDocs matchingDocs = null;
            DocIdSetIterator docIdSetIterator = null;
            int nextDocId = Integer.MAX_VALUE;

            protected Integer computeNext() {
                try {
                    this.loadNextMatchingDocsIfRequired();
                    if (this.nextDocId == Integer.MAX_VALUE) {
                        return (Integer)this.endOfData();
                    }
                    int ret = this.nextDocId;
                    this.nextDocId = this.docIdSetIterator.nextDoc();
                    return this.matchingDocs.context.docBase + ret;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void loadNextMatchingDocsIfRequired() throws IOException {
                while (this.nextDocId == Integer.MAX_VALUE) {
                    if (matchingDocsListIterator.hasNext()) {
                        this.matchingDocs = (FacetsCollector.MatchingDocs)matchingDocsListIterator.next();
                        this.docIdSetIterator = this.matchingDocs.bits.iterator();
                        this.nextDocId = this.docIdSetIterator.nextDoc();
                        continue;
                    }
                    return;
                }
            }
        };
    }

    private Iterator<Integer> getSampledMatchingDocIterator(Iterator<Integer> matchingDocs, long randomdSeed, int hitCount, int sampleSize) {
        TapeSampling<Integer> tapeSampling = new TapeSampling<Integer>(new Random(randomdSeed), matchingDocs, hitCount, sampleSize);
        return tapeSampling.getSamples();
    }

    private int getAccessibleSampleCount(String dim, Iterator<Integer> sampleIterator) throws IOException {
        int count = 0;
        while (sampleIterator.hasNext()) {
            int docId = sampleIterator.next();
            Document doc = this.reader.document(docId);
            if (!this.filter.isAccessible(doc.getField(":path").stringValue() + "/" + dim)) continue;
            ++count;
        }
        return count;
    }

    private LabelAndValue[] updateLabelAndValueIfRequired(LabelAndValue[] labelAndValues, int sampleSize, int accessibleCount) {
        if (accessibleCount < sampleSize) {
            LabelAndValue[] newValues;
            int numZeros = 0;
            LabelAndValue[] proportionedLVs = new LabelAndValue[labelAndValues.length];
            for (int i = 0; i < labelAndValues.length; ++i) {
                LabelAndValue lv = labelAndValues[i];
                long count = lv.value.longValue() * (long)accessibleCount / (long)sampleSize;
                if (count == 0L) {
                    ++numZeros;
                }
                proportionedLVs[i] = new LabelAndValue(lv.label, count);
            }
            labelAndValues = proportionedLVs;
            if (numZeros > 0) {
                newValues = new LabelAndValue[labelAndValues.length - numZeros];
                int i = 0;
                for (LabelAndValue lv : labelAndValues) {
                    if (lv.value.longValue() <= 0L) continue;
                    newValues[i++] = lv;
                }
            } else {
                newValues = labelAndValues;
            }
            return newValues;
        }
        return labelAndValues;
    }
}

