/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.Closeable;
import java.util.List;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class LuceneIndexProvider
implements QueryIndexProvider,
Observer,
Closeable {
    protected final IndexTracker tracker;
    protected volatile QueryIndex.NodeAggregator aggregator = null;
    IndexAugmentorFactory augmentorFactory;

    public LuceneIndexProvider() {
        this(new IndexTracker());
    }

    public LuceneIndexProvider(IndexCopier indexCopier) {
        this(new IndexTracker(indexCopier));
    }

    public LuceneIndexProvider(IndexTracker tracker) {
        this(tracker, null);
    }

    public LuceneIndexProvider(IndexTracker tracker, IndexAugmentorFactory augmentorFactory) {
        this.tracker = tracker;
        this.augmentorFactory = augmentorFactory;
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    @Override
    public void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        this.tracker.update(root);
    }

    @NotNull
    public List<QueryIndex> getQueryIndexes(NodeState nodeState) {
        return ImmutableList.of((Object)new AggregateIndex(this.newLuceneIndex()), (Object)((Object)this.newLucenePropertyIndex()));
    }

    protected LuceneIndex newLuceneIndex() {
        return new LuceneIndex(this.tracker, this.aggregator);
    }

    protected LucenePropertyIndex newLucenePropertyIndex() {
        return new LucenePropertyIndex(this.tracker, this.augmentorFactory);
    }

    public void setAggregator(QueryIndex.NodeAggregator aggregator) {
        this.aggregator = aggregator;
    }

    public LuceneIndexProvider with(QueryIndex.NodeAggregator analyzer) {
        this.setAggregator(analyzer);
        return this;
    }

    IndexTracker getTracker() {
        return this.tracker;
    }
}

