/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.cache.Cache;
import org.apache.jackrabbit.guava.common.cache.LoadingCache;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.io.ByteStreams;
import org.apache.jackrabbit.guava.common.io.Closeables;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.api.blob.BlobDownloadOptions;
import org.apache.jackrabbit.oak.api.blob.BlobUpload;
import org.apache.jackrabbit.oak.api.blob.BlobUploadOptions;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.ExtendedBlobStatsCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.blob.datastore.TypedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordAccessProvider;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordDownloadOptions;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUpload;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.directaccess.DataRecordUploadOptions;
import org.apache.jackrabbit.oak.spi.blob.BlobOptions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.spi.blob.stats.StatsCollectingStreams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2024-09-23")
public class DataStoreBlobStore
implements DataStore,
BlobStore,
GarbageCollectableBlobStore,
BlobTrackingStore,
TypedDataStore,
BlobAccessProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean SHARED_TRANSIENT = Boolean.parseBoolean(System.getProperty("oak.datastore.sharedTransient"));
    protected final DataStore delegate;
    protected BlobStatsCollector stats = ExtendedBlobStatsCollector.NOOP;
    private BlobTracker tracker;
    private final boolean encodeLengthInId;
    protected final LoadingCache<String, byte[]> cache;
    public static final int DEFAULT_CACHE_SIZE = 16;
    private int maxCachedBinarySize = 0x100000;
    private final Weigher<String, byte[]> weigher = new Weigher<String, byte[]>(){

        public int weigh(@NotNull String key, @NotNull byte[] value) {
            long weight = (long)StringUtils.estimateMemoryUsage(key) + (long)value.length;
            if (weight > Integer.MAX_VALUE) {
                DataStoreBlobStore.this.log.debug("Calculated weight larger than Integer.MAX_VALUE: {}.", (Object)weight);
                weight = Integer.MAX_VALUE;
            }
            return (int)weight;
        }
    };
    private final CacheStats cacheStats;
    public static final String MEM_CACHE_NAME = "BlobStore-MemCache";
    private String repositoryId;

    public DataStoreBlobStore(DataStore delegate) {
        this(delegate, true, 16);
    }

    public DataStoreBlobStore(DataStore delegate, boolean encodeLengthInId) {
        this(delegate, encodeLengthInId, 16);
    }

    public DataStoreBlobStore(DataStore delegate, boolean encodeLengthInId, int cacheSizeInMB) {
        this.delegate = delegate;
        this.encodeLengthInId = encodeLengthInId;
        long cacheSize = (long)cacheSizeInMB * 0x100000L;
        this.cache = CacheLIRS.newBuilder().module(MEM_CACHE_NAME).recordStats().maximumWeight(cacheSize).weigher(this.weigher).build();
        this.cacheStats = new CacheStats((Cache<?, ?>)this.cache, MEM_CACHE_NAME, this.weigher, cacheSize);
    }

    @Override
    public DataRecord getRecordIfStored(DataIdentifier identifier) throws DataStoreException {
        try {
            long start = System.nanoTime();
            DataRecord rec = DataStoreBlobStore.isInMemoryRecord(identifier) ? this.getDataRecord(identifier.toString()) : this.delegate.getRecordIfStored(identifier);
            long elapsed = System.nanoTime() - start;
            this.stats.getRecordIfStoredCalled(elapsed, TimeUnit.NANOSECONDS, rec.getLength());
            this.stats.getRecordIfStoredCompleted(identifier.toString());
            return rec;
        }
        catch (DataStoreException e) {
            this.stats.getRecordIfStoredFailed(identifier.toString());
            throw e;
        }
    }

    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        try {
            long start = System.nanoTime();
            DataRecord rec = DataStoreBlobStore.isInMemoryRecord(identifier) ? this.getDataRecord(identifier.toString()) : this.delegate.getRecord(identifier);
            long elapsed = System.nanoTime() - start;
            this.stats.getRecordCalled(elapsed, TimeUnit.NANOSECONDS, rec.getLength());
            this.stats.getRecordCompleted(identifier.toString());
            return rec;
        }
        catch (DataStoreException e) {
            this.stats.getRecordFailed(identifier.toString());
            throw e;
        }
    }

    @Override
    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        try {
            long start = System.nanoTime();
            DataRecord rec = this.delegate.getRecordFromReference(reference);
            long elapsed = System.nanoTime() - start;
            this.stats.getRecordFromReferenceCalled(elapsed, TimeUnit.NANOSECONDS, rec.getLength());
            this.stats.getRecordFromReferenceCompleted(reference);
            return rec;
        }
        catch (DataStoreException e) {
            this.stats.getRecordFromReferenceFailed(reference);
            throw e;
        }
    }

    @Override
    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        try {
            long start = System.nanoTime();
            DataRecord rec = this.writeStream(stream, new BlobOptions());
            this.stats.recordAdded(System.nanoTime() - start, TimeUnit.NANOSECONDS, rec.getLength());
            this.stats.addRecordCompleted(rec.getIdentifier().toString());
            return rec;
        }
        catch (IOException e) {
            this.stats.addRecordFailed();
            throw new DataStoreException(e);
        }
        catch (DataStoreException e) {
            this.stats.addRecordFailed();
            throw e;
        }
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.delegate.updateModifiedDateOnAccess(before);
    }

    @Override
    public int deleteAllOlderThan(long min) throws DataStoreException {
        try {
            long start = System.nanoTime();
            int deletedCount = this.delegate.deleteAllOlderThan(min);
            this.stats.deletedAllOlderThan(System.nanoTime() - start, TimeUnit.NANOSECONDS, min);
            this.stats.deleteAllOlderThanCompleted(deletedCount);
            return deletedCount;
        }
        catch (Exception e) {
            this.stats.deleteAllOlderThanFailed(min);
            throw e;
        }
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        try {
            long start = System.nanoTime();
            Iterator<DataIdentifier> allIdentifiersIterator = this.delegate.getAllIdentifiers();
            this.stats.getAllIdentifiersCalled(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            this.stats.getAllIdentifiersCompleted();
            return allIdentifiersIterator;
        }
        catch (Exception e) {
            this.stats.getAllIdentifiersFailed();
            throw e;
        }
    }

    @Override
    public void init(String homeDir) throws RepositoryException {
        throw new UnsupportedOperationException("DataStore cannot be initialized again");
    }

    @Override
    public int getMinRecordLength() {
        return this.delegate.getMinRecordLength();
    }

    @Override
    public void close() throws DataStoreException {
        if (this.SHARED_TRANSIENT && !Strings.isNullOrEmpty((String)this.getRepositoryId())) {
            this.deleteMetadataRecord(SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(this.getRepositoryId()));
        }
        this.delegate.close();
        this.cache.invalidateAll();
        IOUtils.closeQuietly((Closeable)this.tracker);
    }

    @Override
    public String writeBlob(InputStream stream) throws IOException {
        return this.writeBlob(stream, new BlobOptions());
    }

    @Override
    public String writeBlob(InputStream stream, BlobOptions options) throws IOException {
        boolean threw = true;
        try {
            long start = System.nanoTime();
            Objects.requireNonNull(stream);
            DataRecord dr = this.writeStream(stream, options);
            String id = this.getBlobId(dr);
            this.updateTracker(id);
            threw = false;
            this.stats.uploaded(System.nanoTime() - start, TimeUnit.NANOSECONDS, dr.getLength());
            this.stats.uploadCompleted(id);
            String string = id;
            return string;
        }
        catch (DataStoreException e) {
            this.stats.uploadFailed();
            throw new IOException(e);
        }
        finally {
            Closeables.close((Closeable)stream, (boolean)threw);
        }
    }

    private void updateTracker(String id) {
        if (this.tracker != null && !InMemoryDataRecord.isInstance(id)) {
            try {
                this.tracker.add(id);
                this.log.trace("Tracked Id {}", (Object)id);
            }
            catch (Exception e) {
                this.log.warn("Could not add track id", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBlob(String encodedBlobId, long pos, byte[] buff, int off, int length) throws IOException {
        InputStream stream = this.getInputStream(encodedBlobId);
        boolean threw = true;
        try {
            ByteStreams.skipFully((InputStream)stream, (long)pos);
            int readCount = stream.read(buff, off, length);
            threw = false;
            int n = readCount;
            return n;
        }
        finally {
            Closeables.close((Closeable)stream, (boolean)threw);
        }
    }

    @Override
    public long getBlobLength(String encodedBlobId) throws IOException {
        try {
            Objects.requireNonNull(encodedBlobId, "BlobId must be specified");
            BlobId id = BlobId.of(encodedBlobId);
            if (this.encodeLengthInId && id.hasLengthInfo()) {
                return id.length;
            }
            return this.getDataRecord(id.blobId).getLength();
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getBlobId(@NotNull String reference) {
        Objects.requireNonNull(reference);
        try {
            DataRecord record = this.delegate.getRecordFromReference(reference);
            if (record != null) {
                return this.getBlobId(record);
            }
        }
        catch (DataStoreException e) {
            this.log.warn("Unable to access the blobId for  [{}]", (Object)reference, (Object)e);
        }
        return null;
    }

    @Override
    public String getReference(@NotNull String encodedBlobId) {
        Objects.requireNonNull(encodedBlobId);
        String blobId = this.extractBlobId(encodedBlobId);
        if (InMemoryDataRecord.isInstance(blobId)) {
            return null;
        }
        try {
            DataRecord record = this.delegate.getRecordIfStored(new DataIdentifier(blobId));
            if (record != null) {
                return record.getReference();
            }
            this.log.debug("No blob found for id [{}]", (Object)blobId);
        }
        catch (DataStoreException e) {
            this.log.warn("Unable to access the blobId for  [{}]", (Object)blobId, (Object)e);
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String encodedBlobId) throws IOException {
        final BlobId blobId = BlobId.of(encodedBlobId);
        if (this.encodeLengthInId && blobId.hasLengthInfo() && blobId.length <= (long)this.maxCachedBinarySize) {
            try {
                byte[] content = (byte[])this.cache.get((Object)blobId.blobId, (Callable)new Callable<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public byte[] call() throws Exception {
                        boolean threw = true;
                        InputStream stream = DataStoreBlobStore.this.getStream(blobId.blobId);
                        try {
                            byte[] result = IOUtils.toByteArray(stream);
                            threw = false;
                            byte[] byArray = result;
                            return byArray;
                        }
                        finally {
                            Closeables.close((Closeable)stream, (boolean)threw);
                        }
                    }
                });
                return new ByteArrayInputStream(content);
            }
            catch (ExecutionException e) {
                this.log.warn("Error occurred while loading bytes from steam while fetching for id {}", (Object)encodedBlobId, (Object)e);
            }
        }
        try {
            return this.getStream(blobId.blobId);
        }
        catch (IOException e) {
            this.stats.downloadFailed(blobId.blobId);
            throw e;
        }
    }

    @Override
    public void setBlockSize(int x) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeBlob(String tempFileName) throws IOException {
        String string;
        File file = new File(tempFileName);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = this.writeBlob(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            FileUtils.forceDelete(file);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        FileUtils.forceDelete(file);
        return string;
    }

    @Override
    public int sweep() throws IOException {
        return 0;
    }

    @Override
    public void startMark() throws IOException {
    }

    @Override
    public void clearInUse() {
        this.delegate.clearInUse();
    }

    @Override
    public void clearCache() {
    }

    @Override
    public long getBlockSizeMin() {
        return 0L;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        return Iterators.transform((Iterator)Iterators.filter(this.getAllRecords(), input -> input != null && (maxLastModifiedTime <= 0L || input.getLastModified() < maxLastModifiedTime)), input -> {
            if (this.encodeLengthInId) {
                return BlobId.of(input).encodedValue();
            }
            return input.getIdentifier().toString();
        });
    }

    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        return (long)chunkIds.size() == this.countDeleteChunks(chunkIds, maxLastModifiedTime);
    }

    @Override
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        int count = 0;
        if (this.delegate instanceof MultiDataStoreAware) {
            try {
                ArrayList<String> deleted = new ArrayList<String>(512);
                for (String chunkId : chunkIds) {
                    long start = System.nanoTime();
                    String blobId = this.extractBlobId(chunkId);
                    DataIdentifier identifier = new DataIdentifier(blobId);
                    DataRecord dataRecord = this.getRecordForId(identifier);
                    boolean success = maxLastModifiedTime <= 0L || dataRecord.getLastModified() <= maxLastModifiedTime;
                    this.log.trace("Deleting blob [{}] with last modified date [{}] : [{}]", blobId, dataRecord.getLastModified(), success);
                    if (success) {
                        ((MultiDataStoreAware)((Object)this.delegate)).deleteRecord(identifier);
                        deleted.add(blobId);
                        if (++count % 512 == 0) {
                            this.log.info("Deleted blobs {}", (Object)deleted);
                            deleted.clear();
                        }
                    }
                    this.stats.deleted(blobId, System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    this.stats.deleteCompleted(blobId);
                }
                if (!deleted.isEmpty()) {
                    this.log.info("Deleted blobs {}", (Object)deleted);
                }
            }
            catch (Exception e) {
                this.stats.deleteFailed();
                throw e;
            }
        }
        return count;
    }

    @Override
    public Iterator<String> resolveChunks(String blobId) throws IOException {
        if (!InMemoryDataRecord.isInstance(blobId)) {
            return Iterators.singletonIterator((Object)blobId);
        }
        return Collections.emptyIterator();
    }

    @Override
    public void addMetadataRecord(InputStream stream, String name) throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                ((SharedDataStore)((Object)this.delegate)).addMetadataRecord(stream, name);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordAdded(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).addMetadataRecordCompleted(name);
                }
            }
            catch (DataStoreException e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).addMetadataRecordFailed(name);
                }
                throw e;
            }
        }
    }

    @Override
    public void addMetadataRecord(File f, String name) throws DataStoreException {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                ((SharedDataStore)((Object)this.delegate)).addMetadataRecord(f, name);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordAdded(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).addMetadataRecordCompleted(name);
                }
            }
            catch (DataStoreException e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).addMetadataRecordFailed(name);
                }
                throw e;
            }
        }
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                DataRecord record = ((SharedDataStore)((Object)this.delegate)).getMetadataRecord(name);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).getMetadataRecordCalled(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).getMetadataRecordCompleted(name);
                }
                return record;
            }
            catch (Exception e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).getMetadataRecordFailed(name);
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    public boolean metadataRecordExists(String name) {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                boolean exists = ((SharedDataStore)((Object)this.delegate)).metadataRecordExists(name);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordExistsCalled(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordExistsCompleted(name);
                }
                return exists;
            }
            catch (Exception e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordExistsFailed(name);
                }
                throw e;
            }
        }
        return false;
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                List<DataRecord> records = ((SharedDataStore)((Object)this.delegate)).getAllMetadataRecords(prefix);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).getAllMetadataRecordsCalled(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).getAllMetadataRecordsCompleted(prefix);
                }
                return records;
            }
            catch (Exception e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).getAllMetadataRecordsFailed(prefix);
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                boolean deleted = ((SharedDataStore)((Object)this.delegate)).deleteMetadataRecord(name);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).metadataRecordDeleted(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).deleteMetadataRecordCompleted(name);
                }
                return deleted;
            }
            catch (Exception e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).deleteMetadataRecordFailed(name);
                }
                throw e;
            }
        }
        return false;
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        if (this.delegate instanceof SharedDataStore) {
            try {
                long start = System.nanoTime();
                ((SharedDataStore)((Object)this.delegate)).deleteAllMetadataRecords(prefix);
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).allMetadataRecordsDeleted(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    ((ExtendedBlobStatsCollector)this.stats).deleteAllMetadataRecordsCompleted(prefix);
                }
            }
            catch (Exception e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).deleteAllMetadataRecordsFailed(prefix);
                }
                throw e;
            }
        }
    }

    @Override
    public void setRepositoryId(String repositoryId) throws DataStoreException {
        this.repositoryId = repositoryId;
        this.addMetadataRecord(new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repositoryId));
        this.log.info("repositoryId registered in blobstore - [{}]", (Object)repositoryId);
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public Iterator<DataRecord> getAllRecords() throws DataStoreException {
        Iterator result;
        long start = System.nanoTime();
        Iterator iterator = result = this.delegate instanceof SharedDataStore ? ((SharedDataStore)((Object)this.delegate)).getAllRecords() : Iterators.transform(this.delegate.getAllIdentifiers(), input -> {
            try {
                return this.delegate.getRecord((DataIdentifier)input);
            }
            catch (DataStoreException e) {
                this.log.warn("Error occurred while fetching DataRecord for identifier {}", input, (Object)e);
                return null;
            }
        });
        if (this.stats instanceof ExtendedBlobStatsCollector) {
            ((ExtendedBlobStatsCollector)this.stats).getAllRecordsCalled(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            ((ExtendedBlobStatsCollector)this.stats).getAllRecordsCompleted();
        }
        return result;
    }

    @Override
    public DataRecord getRecordForId(DataIdentifier identifier) throws DataStoreException {
        try {
            DataRecord record;
            long start = System.nanoTime();
            DataRecord dataRecord = record = this.delegate instanceof SharedDataStore ? ((SharedDataStore)((Object)this.delegate)).getRecordForId(identifier) : this.delegate.getRecord(identifier);
            if (this.stats instanceof ExtendedBlobStatsCollector) {
                long elapsed = System.nanoTime() - start;
                ((ExtendedBlobStatsCollector)this.stats).getRecordForIdCalled(elapsed, TimeUnit.NANOSECONDS, record.getLength());
                ((ExtendedBlobStatsCollector)this.stats).getRecordForIdCompleted(identifier.toString());
            }
            return record;
        }
        catch (DataStoreException e) {
            if (this.stats instanceof ExtendedBlobStatsCollector) {
                ((ExtendedBlobStatsCollector)this.stats).getRecordForIdFailed(identifier.toString());
            }
            throw e;
        }
    }

    @Override
    public SharedDataStore.Type getType() {
        if (this.delegate instanceof SharedDataStore) {
            return SharedDataStore.Type.SHARED;
        }
        return SharedDataStore.Type.DEFAULT;
    }

    @Override
    public DataRecord addRecord(InputStream input, BlobOptions options) throws DataStoreException {
        try {
            long start = System.nanoTime();
            DataRecord result = this.addRecordInternal(input, options);
            this.stats.recordAdded(System.nanoTime() - start, TimeUnit.NANOSECONDS, result.getLength());
            this.stats.addRecordCompleted(result.getIdentifier().toString());
            return result;
        }
        catch (DataStoreException e) {
            this.stats.addRecordFailed();
            throw e;
        }
    }

    private DataRecord addRecordInternal(InputStream input, BlobOptions options) throws DataStoreException {
        return this.delegate instanceof TypedDataStore ? ((TypedDataStore)((Object)this.delegate)).addRecord(input, options) : this.delegate.addRecord(input);
    }

    public String toString() {
        return String.format("DataStore backed BlobStore [%s]", this.delegate.getClass().getName());
    }

    public DataStore getDataStore() {
        return this.delegate;
    }

    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    public void setMaxCachedBinarySize(int maxCachedBinarySize) {
        this.maxCachedBinarySize = maxCachedBinarySize;
    }

    public void setBlobStatsCollector(BlobStatsCollector stats) {
        this.stats = stats;
    }

    @Override
    public void addTracker(BlobTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    @Nullable
    public BlobTracker getTracker() {
        return this.tracker;
    }

    protected InputStream getStream(String blobId) throws IOException {
        try {
            long startTime = System.nanoTime();
            InputStream in = this.getDataRecord(blobId).getStream();
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return StatsCollectingStreams.wrap(this.stats, blobId, in, startTime);
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
    }

    protected DataRecord getDataRecord(String blobId) throws DataStoreException {
        DataRecord id = InMemoryDataRecord.isInstance(blobId) ? InMemoryDataRecord.getInstance(blobId) : this.delegate.getRecord(new DataIdentifier(blobId));
        Objects.requireNonNull(id, String.format("No DataRecord found for blobId [%s]", blobId));
        return id;
    }

    private static boolean isInMemoryRecord(DataIdentifier identifier) {
        return InMemoryDataRecord.isInstance(identifier.toString());
    }

    private DataRecord writeStream(InputStream in, BlobOptions options) throws IOException, DataStoreException {
        DataRecord record;
        int l;
        int maxMemorySize = Math.max(0, this.delegate.getMinRecordLength() + 1);
        byte[] buffer = new byte[maxMemorySize];
        int pos = 0;
        int len = maxMemorySize;
        while (pos < maxMemorySize && (l = in.read(buffer, pos, len)) >= 0) {
            pos += l;
            len -= l;
        }
        if (pos < maxMemorySize) {
            byte[] data = new byte[pos];
            System.arraycopy(buffer, 0, data, 0, pos);
            record = InMemoryDataRecord.getInstance(data);
        } else {
            in = new SequenceInputStream(new ByteArrayInputStream(buffer, 0, pos), in);
            record = this.addRecordInternal(in, options);
        }
        return record;
    }

    private String getBlobId(DataRecord dr) {
        if (this.encodeLengthInId) {
            return BlobId.of(dr).encodedValue();
        }
        return dr.getIdentifier().toString();
    }

    protected String extractBlobId(String encodedBlobId) {
        if (this.encodeLengthInId) {
            return BlobId.of((String)encodedBlobId).blobId;
        }
        return encodedBlobId;
    }

    @Nullable
    public BlobUpload initiateBlobUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) throws IllegalArgumentException {
        return this.initiateBlobUpload(maxUploadSizeInBytes, maxNumberOfURIs, BlobUploadOptions.DEFAULT);
    }

    @Nullable
    public BlobUpload initiateBlobUpload(long maxUploadSizeInBytes, int maxNumberOfURIs, @NotNull BlobUploadOptions options) throws IllegalArgumentException {
        if (this.delegate instanceof DataRecordAccessProvider) {
            try {
                long start = System.nanoTime();
                DataRecordAccessProvider provider = (DataRecordAccessProvider)this.delegate;
                final DataRecordUpload upload = provider.initiateDataRecordUpload(maxUploadSizeInBytes, maxNumberOfURIs, DataRecordUploadOptions.fromBlobUploadOptions((BlobUploadOptions)options));
                if (upload == null) {
                    if (this.stats instanceof ExtendedBlobStatsCollector) {
                        ((ExtendedBlobStatsCollector)this.stats).initiateBlobUploadFailed();
                    }
                    return null;
                }
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).initiateBlobUpload(System.nanoTime() - start, TimeUnit.NANOSECONDS, maxUploadSizeInBytes, maxNumberOfURIs);
                    ((ExtendedBlobStatsCollector)this.stats).initiateBlobUploadCompleted();
                }
                return new BlobUpload(){

                    @NotNull
                    public String getUploadToken() {
                        return upload.getUploadToken();
                    }

                    public long getMinPartSize() {
                        return upload.getMinPartSize();
                    }

                    public long getMaxPartSize() {
                        return upload.getMaxPartSize();
                    }

                    @NotNull
                    public Collection<URI> getUploadURIs() {
                        return upload.getUploadURIs();
                    }
                };
            }
            catch (DataRecordUploadException e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).initiateBlobUploadFailed();
                }
                this.log.warn("Unable to initiate direct upload", e);
            }
            catch (IllegalArgumentException e) {
                if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).initiateBlobUploadFailed();
                }
                throw e;
            }
        } else if (this.stats instanceof ExtendedBlobStatsCollector) {
            ((ExtendedBlobStatsCollector)this.stats).initiateBlobUploadFailed();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Blob completeBlobUpload(@NotNull String uploadToken) throws IllegalArgumentException {
        if (this.delegate instanceof DataRecordAccessProvider) {
            try {
                long start = System.nanoTime();
                DataRecord record = ((DataRecordAccessProvider)this.delegate).completeDataRecordUpload(uploadToken);
                String id = this.getBlobId(record);
                this.updateTracker(id);
                if (!(this.stats instanceof ExtendedBlobStatsCollector)) return new BlobStoreBlob(this, id);
                ((ExtendedBlobStatsCollector)this.stats).completeBlobUpload(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                ((ExtendedBlobStatsCollector)this.stats).completeBlobUploadCompleted(id);
                return new BlobStoreBlob(this, id);
            }
            catch (DataStoreException | DataRecordUploadException e) {
                this.log.warn("Unable to complete direct upload for upload token {}", (Object)uploadToken, (Object)e);
                if (!(this.stats instanceof ExtendedBlobStatsCollector)) return null;
                ((ExtendedBlobStatsCollector)this.stats).completeBlobUploadFailed();
                return null;
            }
            catch (IllegalArgumentException e) {
                if (!(this.stats instanceof ExtendedBlobStatsCollector)) throw e;
                ((ExtendedBlobStatsCollector)this.stats).completeBlobUploadFailed();
                throw e;
            }
        } else {
            if (!(this.stats instanceof ExtendedBlobStatsCollector)) return null;
            ((ExtendedBlobStatsCollector)this.stats).completeBlobUploadFailed();
        }
        return null;
    }

    @Nullable
    public URI getDownloadURI(@NotNull Blob blob, @NotNull BlobDownloadOptions downloadOptions) {
        if (this.delegate instanceof DataRecordAccessProvider) {
            long start = System.nanoTime();
            String blobId = blob.getContentIdentity();
            if (blobId != null) {
                String extractedBlobId = this.extractBlobId(blobId);
                URI uri = ((DataRecordAccessProvider)this.delegate).getDownloadURI(new DataIdentifier(extractedBlobId), DataRecordDownloadOptions.fromBlobDownloadOptions((BlobDownloadOptions)downloadOptions));
                if (null != uri) {
                    if (this.stats instanceof ExtendedBlobStatsCollector) {
                        ((ExtendedBlobStatsCollector)this.stats).getDownloadURICalled(System.nanoTime() - start, TimeUnit.NANOSECONDS, extractedBlobId);
                        ((ExtendedBlobStatsCollector)this.stats).getDownloadURICompleted(uri.toString());
                    }
                } else if (this.stats instanceof ExtendedBlobStatsCollector) {
                    ((ExtendedBlobStatsCollector)this.stats).getDownloadURIFailed();
                }
                return uri;
            }
        } else if (this.stats instanceof ExtendedBlobStatsCollector) {
            ((ExtendedBlobStatsCollector)this.stats).getDownloadURIFailed();
        }
        return null;
    }

    @Deprecated(since="2024-09-23")
    public static class BlobId {
        static final String SEP = "#";
        final String blobId;
        final long length;

        public String getBlobId() {
            return this.blobId;
        }

        public long getLength() {
            return this.length;
        }

        BlobId(String blobId, long length) {
            this.blobId = blobId;
            this.length = length;
        }

        BlobId(DataRecord dr) {
            long len;
            this.blobId = dr.getIdentifier().toString();
            try {
                len = dr.getLength();
            }
            catch (DataStoreException e) {
                len = -1L;
            }
            this.length = len;
        }

        BlobId(String encodedBlobId) {
            int indexOfSep = encodedBlobId.lastIndexOf(SEP);
            if (indexOfSep != -1) {
                this.blobId = encodedBlobId.substring(0, indexOfSep);
                this.length = Long.valueOf(encodedBlobId.substring(indexOfSep + SEP.length()));
            } else {
                this.blobId = encodedBlobId;
                this.length = -1L;
            }
        }

        String encodedValue() {
            if (this.hasLengthInfo()) {
                return this.blobId + SEP + String.valueOf(this.length);
            }
            return this.blobId;
        }

        boolean hasLengthInfo() {
            return this.length != -1L;
        }

        static boolean isEncoded(String encodedBlobId) {
            return encodedBlobId.contains(SEP);
        }

        public static BlobId of(String encodedValue) {
            return new BlobId(encodedValue);
        }

        static BlobId of(DataRecord dr) {
            return new BlobId(dr);
        }
    }
}

