/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={MountedNodeStoreChecker.class})
public class NodeTypeDefinitionNodeStoreChecker
implements MountedNodeStoreChecker<Context> {
    @Override
    public Context createContext(NodeStore globalStore, MountInfoProvider mip) {
        NodeState nodeTypes = globalStore.getRoot().getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        return new Context(nodeTypes);
    }

    @Override
    public boolean check(final MountedNodeStore mountedStore, Tree tree, final ErrorHolder errorHolder, Context context) {
        TypeEditor.ConstraintViolationCallback callback = new TypeEditor.ConstraintViolationCallback(){

            @Override
            public void onConstraintViolation(String path, List<String> typeNames, int code, String message) throws CommitFailedException {
                errorHolder.report(mountedStore, path, message, NodeTypeDefinitionNodeStoreChecker.this);
            }
        };
        NodeState root = mountedStore.getNodeStore().getRoot();
        ReadOnlyBuilder rootBuilder = new ReadOnlyBuilder(root);
        String primary = root.getName("jcr:primaryType");
        if (primary == null) {
            return false;
        }
        Iterable<String> mixins = root.getNames("jcr:mixinTypes");
        try {
            Set<String> checkNodeTypeNames = context.getAllNodeTypeNames();
            checkNodeTypeNames.remove("oak:QueryIndexDefinition");
            VisibleEditor editor = new VisibleEditor(TypeEditor.create(callback, checkNodeTypeNames, context.nodeTypes, primary, mixins, rootBuilder));
            EditorDiff.process(editor, EmptyNodeState.MISSING_NODE, root);
        }
        catch (CommitFailedException e) {
            errorHolder.report(mountedStore, "/", "Unexpected error : " + e.getMessage(), this);
        }
        return false;
    }

    static class Context {
        private final NodeState nodeTypes;

        private Context(NodeState nodeTypes) {
            this.nodeTypes = nodeTypes;
        }

        private Set<String> getAllNodeTypeNames() {
            HashSet<String> modifiedTypes = new HashSet<String>();
            for (ChildNodeEntry childNodeEntry : this.nodeTypes.getChildNodeEntries()) {
                modifiedTypes.add(childNodeEntry.getNodeState().getName("jcr:nodeTypeName"));
            }
            return modifiedTypes;
        }
    }
}

