/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.guava.common.collect.FluentIterable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.NodeMap;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompositeNodeBuilder
implements NodeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeNodeBuilder.class);
    private final CompositionContext ctx;
    private final NodeMap<NodeBuilder> nodeBuilders;
    private final String path;

    CompositeNodeBuilder(NodeMap<NodeBuilder> nodeBuilders, CompositionContext ctx, String path) {
        this.ctx = ctx;
        this.nodeBuilders = nodeBuilders;
        this.path = path;
        ctx.getNodeBuilderMonitor().onCreateNodeObject(this.getPath());
    }

    NodeBuilder getNodeBuilder(MountedNodeStore mns) {
        return this.nodeBuilders.get(mns);
    }

    @Override
    public CompositeNodeState getNodeState() {
        return new CompositeNodeState(this.getPath(), this.nodeBuilders.getAndApply((mns, b) -> b.exists() ? b.getNodeState() : EmptyNodeState.MISSING_NODE), this.ctx);
    }

    @Override
    public CompositeNodeState getBaseState() {
        return new CompositeNodeState(this.getPath(), this.nodeBuilders.getAndApply((mns, b) -> b.getBaseState()), this.ctx);
    }

    @Override
    public boolean exists() {
        return this.getWrappedNodeBuilder().exists();
    }

    @Override
    public boolean isNew() {
        return this.getWrappedNodeBuilder().isNew();
    }

    @Override
    public boolean isNew(String name) {
        return this.getWrappedNodeBuilder().isNew(name);
    }

    @Override
    public boolean isModified() {
        return this.getWrappedNodeBuilder().isModified();
    }

    @Override
    public boolean isReplaced() {
        return this.getWrappedNodeBuilder().isReplaced();
    }

    @Override
    public boolean isReplaced(String name) {
        return this.getWrappedNodeBuilder().isReplaced(name);
    }

    @Override
    public long getPropertyCount() {
        return this.getWrappedNodeBuilder().getPropertyCount();
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        return this.getWrappedNodeBuilder().getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getWrappedNodeBuilder().hasProperty(name);
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.getWrappedNodeBuilder().getProperty(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getWrappedNodeBuilder().getBoolean(name);
    }

    @Override
    public String getString(String name) {
        return this.getWrappedNodeBuilder().getString(name);
    }

    @Override
    public String getName(String name) {
        return this.getWrappedNodeBuilder().getName(name);
    }

    @Override
    public Iterable<String> getNames(String name) {
        return this.getWrappedNodeBuilder().getNames(name);
    }

    @Override
    public NodeBuilder setProperty(PropertyState property) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(property);
        return this;
    }

    @Override
    public <T> NodeBuilder setProperty(String name, T value) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(name, value);
        return this;
    }

    @Override
    public <T> NodeBuilder setProperty(String name, T value, Type<T> type) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(name, value, type);
        return this;
    }

    @Override
    public NodeBuilder removeProperty(String name) {
        this.getWrappedNodeBuilder().removeProperty(name);
        return this;
    }

    @Override
    public long getChildNodeCount(long max) {
        List<MountedNodeStore> contributingStores = this.ctx.getContributingStoresForBuilders(this.getPath(), this.nodeBuilders);
        if (contributingStores.isEmpty()) {
            return 0L;
        }
        if (contributingStores.size() == 1) {
            return this.getWrappedNodeBuilder().getChildNodeCount(max);
        }
        return CompositeNodeState.accumulateChildSizes((Iterable<String>)FluentIterable.from(contributingStores).transformAndConcat(mns -> {
            NodeBuilder node = this.nodeBuilders.get((MountedNodeStore)mns);
            if (node.getChildNodeCount(max) == Long.MAX_VALUE) {
                return Collections.singleton(CompositeNodeState.STOP_COUNTING_CHILDREN);
            }
            return FluentIterable.from(node.getChildNodeNames()).filter(e -> this.belongsToStore((MountedNodeStore)mns, (String)e));
        }), max);
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return FluentIterable.from(this.ctx.getContributingStoresForBuilders(this.getPath(), this.nodeBuilders)).transformAndConcat(mns -> FluentIterable.from(this.nodeBuilders.get((MountedNodeStore)mns).getChildNodeNames()).filter(e -> this.belongsToStore((MountedNodeStore)mns, (String)e)));
    }

    @Override
    public boolean hasChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        MountedNodeStore mountedStore = this.ctx.getOwningStore(childPath);
        return this.nodeBuilders.get(mountedStore).hasChildNode(name);
    }

    @Override
    public NodeBuilder child(String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Override
    public NodeBuilder getChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        if (!this.ctx.shouldBeComposite(childPath)) {
            MountedNodeStore mns2 = this.ctx.getOwningStore(childPath);
            this.ctx.getNodeBuilderMonitor().onSwitchNodeToNative(mns2.getMount());
            return this.nodeBuilders.get(mns2).getChildNode(name);
        }
        return new CompositeNodeBuilder(this.nodeBuilders.lazyApply((mns, b) -> b.getChildNode(name)), this.ctx, childPath);
    }

    @Override
    public NodeBuilder setChildNode(String name) throws IllegalArgumentException {
        return this.setChildNode(name, EmptyNodeState.EMPTY_NODE);
    }

    @Override
    public NodeBuilder setChildNode(String name, NodeState nodeState) {
        if (!this.exists()) {
            throw new IllegalStateException("This builder does not exist: " + PathUtils.getName(this.getPath()));
        }
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        MountedNodeStore childStore = this.ctx.getOwningStore(childPath);
        if (childStore != this.ctx.getGlobalStore() && !this.nodeBuilders.get(childStore).exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating node in the global store; will become invisible once overlayed: " + childPath);
            }
            childStore = this.ctx.getGlobalStore();
        }
        NodeBuilder childBuilder = this.nodeBuilders.get(childStore).setChildNode(name, nodeState);
        if (!this.ctx.shouldBeComposite(childPath)) {
            return childBuilder;
        }
        return new CompositeNodeBuilder(this.nodeBuilders.lazyApply((mns, b) -> b.getChildNode(name)).replaceNode(childStore, childBuilder), this.ctx, childPath);
    }

    @Override
    public boolean remove() {
        return this.getWrappedNodeBuilder().remove();
    }

    @Override
    public boolean moveTo(NodeBuilder newParent, String newName) {
        return this.getWrappedNodeBuilder().moveTo(newParent, newName);
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        return this.ctx.createBlob(stream);
    }

    private NodeBuilder getWrappedNodeBuilder() {
        return this.nodeBuilders.get(this.ctx.getGlobalStore());
    }

    String getPath() {
        return this.path;
    }

    private boolean belongsToStore(MountedNodeStore mns, String childName) {
        return this.ctx.belongsToStore(mns, this.getPath(), childName);
    }

    static String simpleConcat(String parentPath, String name) {
        AbstractNodeState.checkValidName(name);
        if (PathUtils.denotesRoot(parentPath)) {
            return parentPath + name;
        }
        return new StringBuilder(parentPath.length() + name.length() + 1).append(parentPath).append('/').append(name).toString();
    }
}

