/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.jackrabbit.guava.common.io.ByteSource;

public class LazyInputStream
extends FilterInputStream {
    private final ByteSource byteSource = null;
    private final Supplier<InputStream> inputStreamSupplier;
    private boolean opened;

    public LazyInputStream(Supplier<InputStream> inputStreamSupplier) {
        super(null);
        this.inputStreamSupplier = inputStreamSupplier;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureOpen();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        this.opened = true;
        if (this.in != null) {
            super.close();
        } else {
            this.in = ClosedInputStream.CLOSED_INPUT_STREAM;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.ensureOpenWithUnCheckedException();
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.ensureOpen();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        this.ensureOpenWithUnCheckedException();
        return super.markSupported();
    }

    private void ensureOpen() throws IOException {
        if (!this.opened) {
            this.opened = true;
            this.in = this.inputStreamSupplier != null ? this.inputStreamSupplier.get() : this.byteSource.openStream();
        }
    }

    private void ensureOpenWithUnCheckedException() {
        try {
            this.ensureOpen();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

