/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.List;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RollbackTask.class);
    private final Xid xid;
    private final List<TransactionImpl.TransactionBranch> rms;
    private final Object logMark;
    private final TransactionManagerImpl txManager;
    private int count = 0;
    private int status;
    private XAException cause;
    private boolean everRolledBack;

    public RollbackTask(Xid xid, List<TransactionImpl.TransactionBranch> rms, Object logMark, TransactionManagerImpl txManager) {
        this.xid = xid;
        this.rms = rms;
        this.logMark = logMark;
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RollbackTask rollbackTask = this;
        synchronized (rollbackTask) {
            this.status = 9;
        }
        int index2 = 0;
        while (index2 < this.rms.size()) {
            TransactionImpl.TransactionBranch manager = this.rms.get(index2);
            try {
                try {
                    manager.getCommitter().rollback(manager.getBranchId());
                    this.remove(index2);
                    this.everRolledBack = true;
                }
                catch (XAException e) {
                    log.error("Unexpected exception committing " + manager.getCommitter() + "; continuing to commit other RMs", e);
                    if (e.errorCode >= 100 && e.errorCode <= 107 || e.errorCode == -4) {
                        this.remove(index2);
                        this.everRolledBack = true;
                        continue;
                    }
                    if (e.errorCode == 6) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically rolled back");
                        this.everRolledBack = true;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 5) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically committed and rolled back");
                        this.everRolledBack = true;
                        this.cause = e;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 7) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically committed");
                        this.cause = e;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 4) {
                        ++index2;
                        continue;
                    }
                    if (e.errorCode == -7 || e.errorCode == -3) {
                        if (manager.getCommitter() instanceof NamedXAResource) {
                            String xaResourceName = manager.getResourceName();
                            NamedXAResourceFactory namedXAResourceFactory = this.txManager.getNamedXAResourceFactory(xaResourceName);
                            if (namedXAResourceFactory != null) {
                                try {
                                    TransactionImpl.ReturnableTransactionBranch newManager = new TransactionImpl.ReturnableTransactionBranch(manager.getBranchXid(), namedXAResourceFactory);
                                    this.remove(index2);
                                    this.rms.add(index2, newManager);
                                }
                                catch (SystemException e1) {
                                    ++index2;
                                }
                                continue;
                            }
                            ++index2;
                            continue;
                        }
                        this.remove(index2);
                        continue;
                    }
                    this.remove(index2);
                    this.cause = e;
                }
            }
            catch (XAException e) {
                if (e.errorCode == -4) continue;
                this.cause = e;
            }
        }
        if (this.rms.isEmpty()) {
            try {
                if (this.logMark != null) {
                    this.txManager.getTransactionLog().rollback(this.xid, this.logMark);
                }
                RollbackTask index2 = this;
                synchronized (index2) {
                    this.status = 4;
                }
            }
            catch (LogException e) {
                log.error("Unexpected exception logging commit completion for xid " + this.xid, e);
                this.cause = (XAException)new XAException("Unexpected error logging commit completion for xid " + this.xid).initCause(e);
            }
        } else {
            RollbackTask rollbackTask2 = this;
            synchronized (rollbackTask2) {
                this.status = 5;
            }
            this.txManager.getRetryScheduler().retry(this, this.count++);
        }
    }

    private void remove(int index) {
        TransactionImpl.TransactionBranch manager = this.rms.remove(index);
        if (manager instanceof TransactionImpl.ReturnableTransactionBranch) {
            ((TransactionImpl.ReturnableTransactionBranch)manager).returnXAResource();
        }
    }

    public XAException getCause() {
        return this.cause;
    }

    public boolean isEverRolledBack() {
        return this.everRolledBack;
    }

    public int getStatus() {
        return this.status;
    }
}

