/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.bytesource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.util.IoUtils;

public class ByteSourceFile
extends ByteSource {
    private final File file;

    public ByteSourceFile(File file) {
        super(file.getName());
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlock(long start, int length) throws IOException {
        byte[] byArray;
        RandomAccessFile raf = null;
        boolean canThrow = false;
        try {
            raf = new RandomAccessFile(this.file, "r");
            if (start < 0L || length < 0 || start + (long)length < 0L || start + (long)length > raf.length()) {
                throw new IOException("Could not read block (block start: " + start + ", block length: " + length + ", data length: " + raf.length() + ").");
            }
            byte[] ret = BinaryFunctions.getRAFBytes((RandomAccessFile)raf, (long)start, (int)length, (String)"Could not read value from file");
            canThrow = true;
            byArray = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly((boolean)canThrow, (Closeable[])new Closeable[]{raf});
            throw throwable;
        }
        IoUtils.closeQuietly((boolean)canThrow, (Closeable[])new Closeable[]{raf});
        return byArray;
    }

    public long getLength() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAll() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        boolean canThrow = false;
        try {
            int read;
            is = new FileInputStream(this.file);
            is = new BufferedInputStream(is);
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            byte[] ret = baos.toByteArray();
            canThrow = true;
            byArray = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly((boolean)canThrow, (Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IoUtils.closeQuietly((boolean)canThrow, (Closeable[])new Closeable[]{is});
        return byArray;
    }

    public String getDescription() {
        return "File: '" + this.file.getAbsolutePath() + "'";
    }
}

