/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.el;

import java.beans.FeatureDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitObjectELResolver
extends ELResolver {
    private static final String[] SCOPE_NAMES = new String[]{"applicationScope", "cookie", "header", "headerValues", "initParam", "pageContext", "pageScope", "param", "paramValues", "requestScope", "sessionScope"};
    private static final int APPLICATIONSCOPE = 0;
    private static final int COOKIE = 1;
    private static final int HEADER = 2;
    private static final int HEADERVALUES = 3;
    private static final int INITPARAM = 4;
    private static final int PAGECONTEXT = 5;
    private static final int PAGESCOPE = 6;
    private static final int PARAM = 7;
    private static final int PARAM_VALUES = 8;
    private static final int REQUEST_SCOPE = 9;
    private static final int SESSION_SCOPE = 10;

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int idx;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && property != null && (idx = Arrays.binarySearch(SCOPE_NAMES, property.toString())) >= 0) {
            PageContext page = (PageContext)context.getContext(JspContext.class);
            context.setPropertyResolved(true);
            switch (idx) {
                case 0: {
                    return ScopeManager.get(page).getApplicationScope();
                }
                case 1: {
                    return ScopeManager.get(page).getCookie();
                }
                case 2: {
                    return ScopeManager.get(page).getHeader();
                }
                case 3: {
                    return ScopeManager.get(page).getHeaderValues();
                }
                case 4: {
                    return ScopeManager.get(page).getInitParam();
                }
                case 5: {
                    return ScopeManager.get(page).getPageContext();
                }
                case 6: {
                    return ScopeManager.get(page).getPageScope();
                }
                case 7: {
                    return ScopeManager.get(page).getParam();
                }
                case 8: {
                    return ScopeManager.get(page).getParamValues();
                }
                case 9: {
                    return ScopeManager.get(page).getRequestScope();
                }
                case 10: {
                    return ScopeManager.get(page).getSessionScope();
                }
            }
        }
        return null;
    }

    public Class getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int idx;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && property != null && (idx = Arrays.binarySearch(SCOPE_NAMES, property.toString())) >= 0) {
            context.setPropertyResolved(true);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        int idx;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && property != null && (idx = Arrays.binarySearch(SCOPE_NAMES, property.toString())) >= 0) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException();
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int idx;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && property != null && (idx = Arrays.binarySearch(SCOPE_NAMES, property.toString())) >= 0) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        ArrayList<FeatureDescriptor> feats = new ArrayList<FeatureDescriptor>(SCOPE_NAMES.length);
        for (int i = 0; i < SCOPE_NAMES.length; ++i) {
            FeatureDescriptor feat = new FeatureDescriptor();
            feat.setDisplayName(SCOPE_NAMES[i]);
            feat.setExpert(false);
            feat.setHidden(false);
            feat.setName(SCOPE_NAMES[i]);
            feat.setPreferred(true);
            feat.setValue("resolvableAtDesignTime", Boolean.TRUE);
            feat.setValue("type", String.class);
            feats.add(feat);
        }
        return feats.iterator();
    }

    public Class<String> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    private static abstract class ScopeMap
    extends AbstractMap {
        private ScopeMap() {
        }

        protected abstract Enumeration getAttributeNames();

        protected abstract Object getAttribute(String var1);

        protected void removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        protected void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public final Set entrySet() {
            Enumeration e = this.getAttributeNames();
            HashSet<ScopeEntry> set = new HashSet<ScopeEntry>();
            if (e != null) {
                while (e.hasMoreElements()) {
                    set.add(new ScopeEntry((String)e.nextElement()));
                }
            }
            return set;
        }

        public final Object get(Object key) {
            if (key != null) {
                return this.getAttribute(key.toString());
            }
            return null;
        }

        public final Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                this.removeAttribute(key.toString());
            } else {
                this.setAttribute(key.toString(), value);
            }
            return null;
        }

        public final Object remove(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.removeAttribute(key.toString());
            return null;
        }

        private class ScopeEntry
        implements Map.Entry {
            private final String key;

            public ScopeEntry(String key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return ScopeMap.this.getAttribute(this.key);
            }

            public Object setValue(Object value) {
                if (value == null) {
                    ScopeMap.this.removeAttribute(this.key);
                } else {
                    ScopeMap.this.setAttribute(this.key, value);
                }
                return null;
            }

            public boolean equals(Object obj) {
                return obj != null && this.hashCode() == obj.hashCode();
            }

            public int hashCode() {
                return this.key.hashCode();
            }
        }
    }

    private static class ScopeManager {
        private static final String MNGR_KEY = ScopeManager.class.getName();
        private final PageContext page;
        private Map applicationScope;
        private Map cookie;
        private Map header;
        private Map headerValues;
        private Map initParam;
        private Map pageScope;
        private Map param;
        private Map paramValues;
        private Map requestScope;
        private Map sessionScope;

        public ScopeManager(PageContext page) {
            this.page = page;
        }

        public static ScopeManager get(PageContext page) {
            ScopeManager mngr = (ScopeManager)page.getAttribute(MNGR_KEY);
            if (mngr == null) {
                mngr = new ScopeManager(page);
                page.setAttribute(MNGR_KEY, mngr);
            }
            return mngr;
        }

        public Map getApplicationScope() {
            if (this.applicationScope == null) {
                this.applicationScope = new ScopeMap(){

                    protected void setAttribute(String name, Object value) {
                        ScopeManager.this.page.getServletContext().setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        ScopeManager.this.page.getServletContext().removeAttribute(name);
                    }

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getServletContext().getAttributeNames();
                    }

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getServletContext().getAttribute(name);
                    }
                };
            }
            return this.applicationScope;
        }

        public Map getCookie() {
            if (this.cookie == null) {
                this.cookie = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        Cookie[] c = ((HttpServletRequest)ScopeManager.this.page.getRequest()).getCookies();
                        if (c != null) {
                            Vector<String> v = new Vector<String>();
                            for (int i = 0; i < c.length; ++i) {
                                v.add(c[i].getName());
                            }
                            return v.elements();
                        }
                        return null;
                    }

                    protected Object getAttribute(String name) {
                        Cookie[] c = ((HttpServletRequest)ScopeManager.this.page.getRequest()).getCookies();
                        if (c != null) {
                            for (int i = 0; i < c.length; ++i) {
                                if (!name.equals(c[i].getName())) continue;
                                return c[i];
                            }
                        }
                        return null;
                    }
                };
            }
            return this.cookie;
        }

        public Map getHeader() {
            if (this.header == null) {
                this.header = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return ((HttpServletRequest)ScopeManager.this.page.getRequest()).getHeaderNames();
                    }

                    protected Object getAttribute(String name) {
                        return ((HttpServletRequest)ScopeManager.this.page.getRequest()).getHeader(name);
                    }
                };
            }
            return this.header;
        }

        public Map getHeaderValues() {
            if (this.headerValues == null) {
                this.headerValues = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return ((HttpServletRequest)ScopeManager.this.page.getRequest()).getHeaderNames();
                    }

                    protected Object getAttribute(String name) {
                        Enumeration<String> e = ((HttpServletRequest)ScopeManager.this.page.getRequest()).getHeaders(name);
                        if (e != null) {
                            ArrayList<String> list = new ArrayList<String>();
                            while (e.hasMoreElements()) {
                                list.add(e.nextElement().toString());
                            }
                            return list.toArray(new String[list.size()]);
                        }
                        return null;
                    }
                };
            }
            return this.headerValues;
        }

        public Map getInitParam() {
            if (this.initParam == null) {
                this.initParam = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getServletContext().getInitParameterNames();
                    }

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getServletContext().getInitParameter(name);
                    }
                };
            }
            return this.initParam;
        }

        public PageContext getPageContext() {
            return this.page;
        }

        public Map getPageScope() {
            if (this.pageScope == null) {
                this.pageScope = new ScopeMap(){

                    protected void setAttribute(String name, Object value) {
                        ScopeManager.this.page.setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        ScopeManager.this.page.removeAttribute(name);
                    }

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getAttributeNamesInScope(1);
                    }

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getAttribute(name);
                    }
                };
            }
            return this.pageScope;
        }

        public Map getParam() {
            if (this.param == null) {
                this.param = new ScopeMap(){

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getRequest().getParameterNames();
                    }

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getRequest().getParameter(name);
                    }
                };
            }
            return this.param;
        }

        public Map getParamValues() {
            if (this.paramValues == null) {
                this.paramValues = new ScopeMap(){

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getRequest().getParameterValues(name);
                    }

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getRequest().getParameterNames();
                    }
                };
            }
            return this.paramValues;
        }

        public Map getRequestScope() {
            if (this.requestScope == null) {
                this.requestScope = new ScopeMap(){

                    protected void setAttribute(String name, Object value) {
                        ScopeManager.this.page.getRequest().setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        ScopeManager.this.page.getRequest().removeAttribute(name);
                    }

                    protected Enumeration getAttributeNames() {
                        return ScopeManager.this.page.getRequest().getAttributeNames();
                    }

                    protected Object getAttribute(String name) {
                        return ScopeManager.this.page.getRequest().getAttribute(name);
                    }
                };
            }
            return this.requestScope;
        }

        public Map getSessionScope() {
            if (this.sessionScope == null) {
                this.sessionScope = new ScopeMap(){

                    protected void setAttribute(String name, Object value) {
                        ((HttpServletRequest)ScopeManager.this.page.getRequest()).getSession().setAttribute(name, value);
                    }

                    protected void removeAttribute(String name) {
                        HttpSession session = ScopeManager.this.page.getSession();
                        if (session != null) {
                            session.removeAttribute(name);
                        }
                    }

                    protected Enumeration getAttributeNames() {
                        HttpSession session = ScopeManager.this.page.getSession();
                        if (session != null) {
                            return session.getAttributeNames();
                        }
                        return null;
                    }

                    protected Object getAttribute(String name) {
                        HttpSession session = ScopeManager.this.page.getSession();
                        if (session != null) {
                            return session.getAttribute(name);
                        }
                        return null;
                    }
                };
            }
            return this.sessionScope;
        }
    }
}

