/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

public class JavaVersion {
    private static final Package specPackage = new ClassLoader(){

        Package createPackage() {
            return this.definePackage("dummy.package", System.getProperty("java.specification.name"), System.getProperty("java.specification.version"), System.getProperty("java.specification.vendor"), "Java Runtime Environment", System.getProperty("java.version"), System.getProperty("java.vendor"), null);
        }
    }.createPackage();
    private static final String specVersion13 = "1.3";
    private static final String specVersion14 = "1.4";
    private static final String specVersion15 = "1.5";

    private JavaVersion() {
    }

    public static String getVersion() {
        return specPackage.getImplementationVersion();
    }

    public static String getSpecificationVersion() {
        return specPackage.getSpecificationVersion();
    }

    public static boolean is13() {
        return JavaVersion.isSpecificationVersion(specVersion13);
    }

    public static boolean is14() {
        return JavaVersion.isSpecificationVersion(specVersion14);
    }

    public static boolean is15() {
        return JavaVersion.isSpecificationVersion(specVersion15);
    }

    public static boolean isSpecificationVersion(String specVersion) {
        if (specVersion == null || specVersion.length() == 0) {
            return false;
        }
        return specVersion.equals(JavaVersion.getSpecificationVersion());
    }

    public static boolean isCompatibleWith13() {
        return JavaVersion.isCompatibleWith(specVersion13);
    }

    public static boolean isCompatibleWith14() {
        return JavaVersion.isCompatibleWith(specVersion14);
    }

    public static boolean isCompatibleWith15() {
        return JavaVersion.isCompatibleWith(specVersion15);
    }

    public static boolean isCompatibleWith(String specVersion) {
        return specPackage.isCompatibleWith(specVersion);
    }
}

