/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.wcm.foundation.impl.WCMRenditionPickerConfig;
import java.util.Iterator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class WCMRenditionPicker
implements RenditionPicker {
    private static final String WEB_RENDITION_PREFIX = "cq5dam.web.";

    @Override
    public Rendition getRendition(Asset asset) {
        ServiceReference serviceRef;
        BundleContext bundleContext;
        WCMRenditionPickerConfig renditionPickerConfig;
        int defaultRenditionWidth = 1280;
        Bundle bundle = FrameworkUtil.getBundle(WCMRenditionPicker.class);
        if (bundle != null && (renditionPickerConfig = (WCMRenditionPickerConfig)(bundleContext = bundle.getBundleContext()).getService(serviceRef = bundleContext.getServiceReference(WCMRenditionPickerConfig.class.getName()))) != null) {
            defaultRenditionWidth = renditionPickerConfig.getDefaultRenditionWidth();
        }
        String defaultRenditionPrefix = WEB_RENDITION_PREFIX + defaultRenditionWidth;
        Iterator<Rendition> renditions = asset.listRenditions();
        Rendition webRenditionFallback = null;
        while (renditions.hasNext()) {
            Rendition rendition = renditions.next();
            if (rendition.getName().startsWith(defaultRenditionPrefix)) {
                return rendition;
            }
            if (webRenditionFallback != null || !rendition.getName().startsWith(WEB_RENDITION_PREFIX)) continue;
            webRenditionFallback = rendition;
        }
        if (webRenditionFallback != null) {
            return webRenditionFallback;
        }
        return asset.getOriginal();
    }
}

