/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.HashMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.xml.sax.Attributes;

public class TitleComponentTagHandler
extends AbstractTagHandler {
    private String resourceType;
    private String type;
    private String suffix;
    private int stackCounter = 0;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        if (localName.matches("[hH][1-6]")) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                modAttibutes.removeAttribute(index);
            }
            this.startElement(uri, localName, qName, modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (this.type == null) {
            if (!localName.matches("[hH][1-6]")) {
                throw new UnsupportedTagContentException("0412");
            }
        } else {
            throw new UnsupportedTagContentException("0413");
        }
        this.type = localName.toLowerCase();
        ++this.stackCounter;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        super.characters(ch, start, length);
        if (this.stackCounter == 0 && new String(ch, start, length).trim().length() > 0) {
            throw new UnsupportedTagContentException("0411");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        super.endElement(uri, localName, qName);
        --this.stackCounter;
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if (localName.matches("[hH][1-6]")) {
            this.endElement(uri, localName, qName);
        }
        HashMap<String, Object> base = new HashMap<String, Object>();
        base.put("jcr:title", this.htmlBuffer.toString());
        base.put("type", this.type);
        ValueMapDecorator properties = new ValueMapDecorator(base);
        this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix("title");
        PageComponent titleComponent = this.pageBuilder.createComponent(this.resourceType, properties, this.getNameHint());
        this.getPageComponents().add(titleComponent);
        this.type = null;
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    private String getNameHint() {
        return "title" + this.suffix;
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(this.componentDivStartTag);
        }
        return null;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

