/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.utils;

import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

public class ScaffoldingUtils {
    public static String CONTEXT_RESOURCE_ATTR_NAME = "com.day.cq.wcm.scaffolding.resource";

    public static String findScaffoldByTemplate(Node node, String template) throws RepositoryException {
        String tt;
        if (node.hasProperty("jcr:content/cq:targetTemplate") && (tt = node.getProperty("jcr:content/cq:targetTemplate").getString()).equals(template)) {
            return node.getPath();
        }
        NodeIterator iter = node.getNodes();
        String scaffold = null;
        while (scaffold == null && iter.hasNext()) {
            Node child = iter.nextNode();
            if (child.getName().equals("jcr:content")) continue;
            scaffold = ScaffoldingUtils.findScaffoldByTemplate(child, template);
        }
        return scaffold;
    }

    public static String findScaffoldByPath(Node node, String path) throws RepositoryException {
        String tt;
        if (node.hasProperty("jcr:content/cq:targetPath") && Text.isDescendantOrEqual(tt = node.getProperty("jcr:content/cq:targetPath").getString(), path)) {
            return node.getPath();
        }
        NodeIterator iter = node.getNodes();
        String scaffold = null;
        while (scaffold == null && iter.hasNext()) {
            Node child = iter.nextNode();
            if (child.getName().equals("jcr:content")) continue;
            scaffold = ScaffoldingUtils.findScaffoldByPath(child, path);
        }
        return scaffold;
    }
}

