/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.stats;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.core.stats.PageView;
import com.day.crx.statistics.Report;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;

public class PageViewReport
extends Report {
    private int period = 30;
    private final Page page;
    private final WCMMode mode;

    public PageViewReport(String dataPath, Page page, WCMMode mode) {
        super(dataPath);
        this.page = page;
        this.mode = mode;
    }

    @Override
    public Iterator<Object[]> getResult(Session session) throws RepositoryException {
        PageView view = new PageView(this.getDataPath(), this.page, this.mode);
        if (!session.itemExists(Text.getRelativeParent(view.getPath(), 4))) {
            return Collections.emptySet().iterator();
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -(this.getPeriod() - 1));
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < this.getPeriod(); ++i) {
            view.setTimestamp(cal.getTimeInMillis());
            long count = 0L;
            long rolling = 0L;
            Node node = this.getNode(view, session);
            if (node != null) {
                count = node.getProperty("views").getLong();
                rolling = node.getProperty("rollingMonthViews").getLong();
            } else {
                int j;
                Calendar back = Calendar.getInstance();
                back.setTimeInMillis(cal.getTimeInMillis());
                for (j = 1; j < 30; ++j) {
                    back.add(5, -1);
                    view.setTimestamp(back.getTimeInMillis());
                    node = this.getNode(view, session);
                    if (node == null || !node.hasProperty("rollingMonthViews")) continue;
                    rolling = node.getProperty("rollingMonthViews").getLong();
                    break;
                }
                if (rolling > 0L) {
                    back.add(5, -29);
                    while (j > 0) {
                        view.setTimestamp(back.getTimeInMillis());
                        node = this.getNode(view, session);
                        if (node != null && node.hasProperty("views")) {
                            rolling -= node.getProperty("views").getLong();
                        }
                        back.add(5, 1);
                        --j;
                    }
                }
                view.setTimestamp(cal.getTimeInMillis());
            }
            data.add(new Object[]{view.getPath(), count, rolling});
            cal.add(5, 1);
        }
        return data.iterator();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    protected Page getPage() {
        return this.page;
    }

    protected WCMMode getMode() {
        return this.mode;
    }

    private Node getNode(PageView view, Session session) {
        try {
            Item item;
            if (session.itemExists(view.getPath()) && (item = session.getItem(view.getPath())).isNode()) {
                return (Node)item;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }
}

