/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import java.util.Iterator;
import java.util.Stack;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class DeepResourceIterator
implements Iterator<Resource> {
    final ResourceResolver resolver;
    final Stack<Iterator<Resource>> resourceTreeStack = new Stack();
    Resource current;

    public DeepResourceIterator(Resource resource) {
        this.resolver = resource.getResourceResolver();
        this.resourceTreeStack.push(this.resolver.listChildren(resource));
        this.current = this.seek();
    }

    private Resource seek() {
        while (this.resourceTreeStack.size() > 0) {
            Iterator<Resource> iter = this.resourceTreeStack.peek();
            if (iter.hasNext()) {
                Resource res = iter.next();
                this.resourceTreeStack.push(this.resolver.listChildren(res));
                return res;
            }
            this.resourceTreeStack.pop();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Resource next() {
        Resource resource = this.current;
        this.current = this.seek();
        return resource;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not possible on event iterator returned by CqCalendar.getEvents()");
    }
}

