/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.Row;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceVendor(value="Adobe Systems Incorporated")
@Component(factory="com.day.cq.search.eval.PredicateEvaluator/hasPermission")
public class PermissionPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String HAS_PERMISSION_PREDICATE = "hasPermission";
    private static final Logger log = LoggerFactory.getLogger(PermissionPredicateEvaluator.class);

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(HAS_PERMISSION_PREDICATE)) {
            return true;
        }
        try {
            ResourceResolver resolver = context.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            AccessControlManager acm = session.getAccessControlManager();
            Resource resource = context.getResource(row);
            String[] permissions = p.get(HAS_PERMISSION_PREDICATE).split(",");
            Privilege[] privileges = new Privilege[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                privileges[i] = acm.privilegeFromName(permissions[i]);
            }
            return acm.hasPrivileges(resource.getPath(), privileges);
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.error("Exception occured while evaluating hasPermission predicate", e);
        }
        catch (RepositoryException e) {
            log.error("Exception occured while evaluating hasPermission predicate", e);
        }
        return false;
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }
}

