/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.reporting;

import com.day.cq.reporting.CellValue;
import com.day.cq.reporting.ChartData;
import com.day.cq.reporting.Column;
import com.day.cq.reporting.DataRow;
import com.day.cq.reporting.Processor;
import com.day.cq.reporting.Report;
import com.day.cq.reporting.ReportExtensions;
import com.day.cq.reporting.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Data {
    protected static final Logger log = LoggerFactory.getLogger(Data.class);
    protected Report report;
    protected final List<DataRow> rows;
    protected final Map<Column, CellValue> columnTotals;
    protected final boolean hasGroupedColumns;
    protected boolean isCompacted;
    protected List<Column> columns;
    protected int reportingVersion;

    public Data(Report report) {
        this.report = report;
        this.hasGroupedColumns = this.report.hasGroupedColumns();
        this.columnTotals = new HashMap<Column, CellValue>();
        this.rows = new ArrayList<DataRow>(16);
        this.isCompacted = false;
        this.reportingVersion = report instanceof ReportExtensions ? ((ReportExtensions)((Object)report)).getReportingVersion() : 0;
    }

    protected void ensureMutable() {
        if (this.isCompacted) {
            throw new IllegalStateException("Report data is already compacted and therefore immutable.");
        }
    }

    protected void ensureImmutable() {
        if (!this.isCompacted) {
            throw new IllegalStateException("Report data must be compacted before writing to JSON");
        }
    }

    public boolean hasGroupedColumns() {
        return this.hasGroupedColumns;
    }

    public void addRow(DataRow rowToAdd) {
        this.ensureMutable();
        log.debug("Adding row; value: {}", (Object)rowToAdd);
        this.rows.add(rowToAdd);
    }

    public DataRow getRowAt(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public int getRowCnt() {
        return this.rows.size();
    }

    public Iterator<Column> getColumns() {
        this.ensureImmutable();
        return this.columns.iterator();
    }

    public void addColumnTotal(Column col, CellValue total) {
        this.ensureMutable();
        this.columnTotals.put(col, total);
    }

    public CellValue getColumnTotal(Column col) {
        return this.columnTotals.get(col);
    }

    public void compact() {
        this.ensureMutable();
        this.isCompacted = true;
        Iterator<Column> cols = this.report.getColumnIterator();
        this.columns = new ArrayList<Column>();
        while (cols.hasNext()) {
            this.columns.add(cols.next());
        }
        ((ArrayList)this.columns).trimToSize();
        this.report = null;
        ((ArrayList)this.rows).trimToSize();
        for (DataRow row : this.rows) {
            row.compact();
        }
    }

    public void postProcess(Processor[] processors) {
        this.ensureMutable();
        log.debug("Postprocessing result data");
        for (int r = this.getRowCnt() - 1; r >= 0; --r) {
            log.debug("Postprocessing row #{}", (Object)r);
            DataRow row = this.rows.get(r);
            for (Processor processor : processors) {
                log.debug("Applying processor {}", (Object)processor.getClass().getSimpleName());
                if (!processor.processRow(row)) continue;
                log.debug("Processor requested removal of record {}; removing record", (Object)row);
                this.rows.remove(r);
            }
        }
    }

    public void sortByColumn(final Column sortingColumn, Sorting.Direction sortingDirection) {
        this.ensureMutable();
        final boolean isAscending = sortingDirection == Sorting.Direction.ASCENDING;
        log.debug("Sorting result for column {}", (Object)sortingColumn.getName());
        Collections.sort(this.rows, new Comparator<DataRow>(){

            @Override
            public int compare(DataRow o1, DataRow o2) {
                int cmpResult;
                String resultProp = sortingColumn.getName();
                CellValue val1 = o1.get(resultProp);
                CellValue val2 = o2.get(resultProp);
                if (val1 == null) {
                    cmpResult = val2 == null ? 0 : -1;
                } else if (val2 == null) {
                    cmpResult = 1;
                } else {
                    try {
                        cmpResult = val1.compareTo(val2);
                    }
                    catch (IllegalStateException e) {
                        return val1.toString().compareTo(val2.toString());
                    }
                }
                if (!isAscending) {
                    cmpResult = -cmpResult;
                }
                return cmpResult;
            }
        });
    }

    public void postProcess(Processor processor) {
        this.ensureMutable();
        this.postProcess(new Processor[]{processor});
    }

    public int getReportingVersion() {
        return this.reportingVersion;
    }

    public abstract ChartData createChartData(int var1);

    public abstract void writeTypesJSON(JSONWriter var1) throws JSONException;

    public abstract void writeSortInfoJSON(JSONWriter var1) throws JSONException;

    public abstract void writeDataJSON(JSONWriter var1, Locale var2, Integer var3, Integer var4) throws JSONException;
}

