/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventProperties;

public class ReplicationEvent
implements Serializable {
    public static final String EVENT_TOPIC = "com/adobe/granite/replication";
    public static final String PATHS = "paths";
    private static final String PROPERTY_MODIFICATIONS = "modifications";
    private static final String TYPE = "type";
    private static final String TIME = "time";
    private static final String USER_ID = "userId";
    private static final String REVISION = "revision";
    private ReplicationAction replicationAction;
    private final boolean isLocal;

    public ReplicationEvent(ReplicationAction replicationAction) {
        this(replicationAction, true);
    }

    public ReplicationEvent(ReplicationAction replicationAction, boolean isLocal) {
        this.replicationAction = replicationAction;
        this.isLocal = isLocal;
    }

    public ReplicationAction getReplicationAction() {
        return this.replicationAction;
    }

    public static ReplicationEvent fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        ReplicationAction action = null;
        List modProps = (List)evt.getProperty(PROPERTY_MODIFICATIONS);
        if (modProps != null && modProps.size() == 1) {
            Map modProp = (Map)modProps.get(0);
            String[] paths = (String[])modProp.get(PATHS);
            ReplicationActionType type = (ReplicationActionType)((Object)modProp.get(TYPE));
            Long time = (Long)modProp.get(TIME);
            String userId = (String)modProp.get(USER_ID);
            String revision = (String)modProp.get(REVISION);
            action = new ReplicationAction(type, paths, (long)time, userId, revision);
        }
        if (action == null) {
            throw new RuntimeException();
        }
        return new ReplicationEvent(action, evt.getProperty("event.application") == null);
    }

    protected Map<String, Object> getEventProperties(boolean distribute) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList modProps = new ArrayList();
        HashMap<String, Object> actionProps = new HashMap<String, Object>();
        actionProps.put(PATHS, this.replicationAction.getPaths());
        actionProps.put(TYPE, (Object)this.replicationAction.getType());
        actionProps.put(TIME, this.replicationAction.getTime());
        actionProps.put(USER_ID, this.replicationAction.getUserId());
        actionProps.put(REVISION, this.replicationAction.getRevision());
        modProps.add(actionProps);
        properties.put(PROPERTY_MODIFICATIONS, modProps);
        if (!this.isLocal) {
            properties.put("event.application", "unknown");
        }
        if (distribute) {
            properties.put("event.distribute", "");
        }
        return new EventProperties(properties);
    }

    public Event toEvent() {
        return new Event(EVENT_TOPIC, this.getEventProperties(true));
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, this.getEventProperties(false));
    }
}

