/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.AggregateHandler;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregateHandler
implements AggregateHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultAggregateHandler.class);
    private boolean removeNodes;

    public boolean isRemoveNodes() {
        return this.removeNodes;
    }

    public void setRemoveNodes(boolean removeNodes) {
        this.removeNodes = removeNodes;
    }

    @Override
    public boolean isAggregateRoot(Node node) {
        try {
            return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}hierarchyNode");
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine aggregate root.", e);
            return false;
        }
    }

    @Override
    public List<String> prepareForReplication(Session session, ReplicationActionType type, String path) throws ReplicationException {
        LinkedList<String> paths = new LinkedList<String>();
        if (type == ReplicationActionType.DELETE || type == ReplicationActionType.DEACTIVATE) {
            try {
                if (session.nodeExists(path)) {
                    this.collectAggregatePaths(session.getNode(path), paths);
                }
                paths.add(path);
            }
            catch (RepositoryException e) {
                throw new ReplicationException("Unable to prepare aggregate roots.", e);
            }
        } else {
            paths.add(path);
        }
        return paths;
    }

    protected void collectAggregatePaths(Node root, List<String> paths) throws RepositoryException {
        paths.add(root.getPath());
        NodeIterator iter = root.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!this.isAggregateRoot(node)) continue;
            this.collectAggregatePaths(node, paths);
        }
    }

    @Override
    public void processForReplication(Session session, ReplicationAction action) throws ReplicationException {
        if (action.getType() == ReplicationActionType.DELETE && this.isRemoveNodes()) {
            for (String path : action.getPaths()) {
                try {
                    if (!session.nodeExists(path)) continue;
                    session.getNode(path).remove();
                }
                catch (RepositoryException e) {
                    log.warn("Unable to remove aggregate at {}: {}", (Object)path, (Object)e.toString());
                }
            }
        }
    }
}

