/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics;

import com.day.cq.graphics.chart.Axis;
import com.day.cq.graphics.chart.Chart;
import com.day.cq.graphics.chart.Data;
import com.day.cq.graphics.chart.Grid;
import com.day.cq.graphics.chart.Metrics;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph {
    private static final Logger log = LoggerFactory.getLogger(Graph.class);
    private static final Color DEFAULT_BGCOLOR = Color.white;
    public static final int FLAGS_FIT = 1;
    public static final int FLAGS_NON_ANTI_ALIASED = 16;
    private static final int FLAGS_UNDEFINED = 32768;
    private static final Grid DEFAULT_GRID = new Grid(null, null);
    private Color bgcolor = DEFAULT_BGCOLOR;
    private final Chart chart;
    private Data data;
    private final Rectangle extent;
    private int flags = 32768;
    private Grid grid = DEFAULT_GRID;
    private int maxcols = 0;
    private int maxrows = 0;
    private final Metrics metrics;
    private Axis x;
    private Axis y;

    public Graph(int width, int height, String type) {
        this.chart = Chart.getInstance(type);
        this.extent = new Rectangle(width, height);
        this.metrics = new Metrics();
    }

    public void initGraphSamples(String[] labels, String[] legends, double[][] samples) {
        if (this.data != null) {
            log.info("initGraphSamples: Samples have already been defined");
            return;
        }
        if (samples == null || samples.length == 0 || samples[0] == null || samples[0].length == 0) {
            log.warn("initGraphSamples: Missing sample data");
            return;
        }
        if (labels == null) {
            labels = new String[]{};
        }
        if (legends == null) {
            legends = new String[]{};
        }
        int numrows = samples.length;
        int numcols = samples[0].length;
        if (this.maxrows > 0 && numrows > this.maxrows) {
            numrows = this.maxrows;
        }
        if (this.maxcols > 0 && numcols > this.maxcols) {
            numcols = this.maxcols;
        }
        this.data = new Data(numrows, numcols);
        this.data.setSamples(samples);
        this.data.setLabels(labels);
        this.data.setLegends(legends);
    }

    public void initGraphSamples(String[][] dataTable, boolean nocateg, boolean nolabels) {
        if (this.data != null) {
            log.info("initGraphSamples: Samples have already been defined");
            return;
        }
        int numRows = dataTable.length;
        int numCols = dataTable[0].length;
        int rowOff = 0;
        int colOff = 0;
        String[] labels = null;
        String[] legends = null;
        if (!nolabels) {
            --numRows;
            rowOff = 1;
        }
        if (!nocateg) {
            --numCols;
            colOff = 1;
        }
        if (!nolabels) {
            labels = new String[numCols];
            System.arraycopy(dataTable[0], colOff, labels, 0, labels.length);
        }
        if (!nocateg) {
            legends = new String[numRows];
            int i = 0;
            int j = rowOff;
            while (i < legends.length) {
                legends[i] = dataTable[j][0];
                ++i;
                ++j;
            }
        }
        double[][] samples = new double[numRows][numCols];
        for (int i = rowOff; i < dataTable.length; ++i) {
            for (int j = colOff; j < dataTable[i].length; ++j) {
                double val;
                try {
                    val = Double.parseDouble(dataTable[i][j]);
                }
                catch (NumberFormatException nfe) {
                    val = 0.0;
                }
                samples[i - 1][j - 1] = val;
            }
        }
        this.initGraphSamples(labels, legends, samples);
    }

    public Layer draw(boolean doDraw) {
        if (this.data == null) {
            log.info("draw: No data samples to draw. Call initGraphSamples first.");
            return null;
        }
        return this.chart.draw(this, doDraw);
    }

    public Layer createLayer(boolean doDraw, int width, int height) {
        if (doDraw) {
            Layer layer = new Layer(width, height, this.getBgColor());
            if ((this.getFlags() & 0x10) == 0) {
                log.debug("createLayer: Anti-Aliased drawing requested");
                layer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            return layer;
        }
        log.debug("createLayer: No drawing desired, not creating layer");
        return null;
    }

    public void setBgColor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public Color getBgColor() {
        return this.bgcolor;
    }

    public Chart getChart() {
        return this.chart;
    }

    public Data getData() {
        return this.data;
    }

    public Rectangle getExtent() {
        return this.extent;
    }

    public void setFlags(int flags) {
        this.flags = flags & 0xFFFF7FFF;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setMaxcols(int maxcols) {
        if (maxcols >= 0) {
            this.maxcols = maxcols;
        }
    }

    public int getMaxcols() {
        return this.maxcols;
    }

    public void setMaxrows(int maxrows) {
        if (maxrows >= 0) {
            this.maxrows = maxrows;
        }
    }

    public int getMaxrows() {
        return this.maxrows;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setXAxis(Axis x) {
        this.x = x;
    }

    public Axis getXAxis() {
        if (this.x == null) {
            this.x = Axis.getInstance(this);
        }
        return this.x;
    }

    public void setYAxis(Axis y) {
        this.y = y;
    }

    public Axis getYAxis() {
        if (this.y == null) {
            this.y = Axis.getInstance(this);
        }
        return this.y;
    }
}

