/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api.model;

public class IpsApiException
extends RuntimeException {
    private static final long serialVersionUID = -7445252449047486682L;
    int code;
    String reason;
    String ipsApiMethodName;
    private static final int CODE_INTERNAL = -1;
    private static final int CODE_EXTERNAL = -2;

    public IpsApiException(int code, String reason, String ipsApiMethodName) {
        super("IPS API fault code=" + String.valueOf(code) + ": " + reason);
        this.code = code;
        this.reason = reason;
        this.ipsApiMethodName = ipsApiMethodName;
    }

    public IpsApiException(String message) {
        super(message);
        this.code = -1;
        this.reason = message;
        this.ipsApiMethodName = "-";
    }

    public IpsApiException(Throwable cause) {
        super(cause);
        this.code = -2;
        this.reason = "Caused by exception: " + cause.getMessage();
        this.ipsApiMethodName = "-";
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public String getIpsApiMethodName() {
        return this.ipsApiMethodName;
    }
}

