/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.predicates;

import com.day.cq.commons.predicates.NodePredicate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Predicate.class}, property={"service.vendor=Adobe Systems Incorporated", "predicate.name=nosystem"})
public class IsNoSystemNodePredicate
implements NodePredicate {
    private final Logger log = LoggerFactory.getLogger(IsNoSystemNodePredicate.class);
    private static final Set<String> EXCLUDES = new HashSet<String>(Arrays.asList("jcr:system", "rep:policy"));

    @Override
    public boolean test(Node node) {
        try {
            return !EXCLUDES.contains(node.getName());
        }
        catch (RepositoryException e) {
            this.log.warn("RepositoryException in evaluate()", e);
            return false;
        }
    }
}

