/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import java.util.ArrayList;
import org.apache.jackrabbit.util.Text;

public class Version
implements Comparable<Version> {
    public static final Version EMPTY = new Version("", new String[0]);
    private final String str;
    private final String[] segments;

    public static Version create(String str) {
        if (str == null || str.length() == 0) {
            return EMPTY;
        }
        return new Version(str, Text.explode(str, 46));
    }

    public static Version create(String[] segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY;
        }
        return new Version(Text.implode(segments, "."), segments);
    }

    private Version(String str, String[] segments) {
        if (str == null) {
            throw new NullPointerException("Version String must not be null.");
        }
        this.str = str;
        ArrayList<String> list = new ArrayList<String>();
        for (String seg : segments) {
            for (String sub : Text.explode(seg, 45)) {
                list.add(sub);
            }
        }
        this.segments = list.toArray(new String[list.size()]);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Version && this.str.equals(((Version)o).str);
    }

    public String toString() {
        return this.str;
    }

    public String[] getNormalizedSegments() {
        return this.segments;
    }

    @Override
    public int compareTo(Version o) {
        String[] oSegs = o.getNormalizedSegments();
        for (int i = 0; i < Math.min(this.segments.length, oSegs.length); ++i) {
            int comp = this.segments[i].compareTo(oSegs[i]);
            if (comp == 0) continue;
            return comp;
        }
        return this.segments.length - oSegs.length;
    }
}

