/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.audit;

import com.day.cq.audit.AuditLogPurgeRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditLogPurgeRule
implements AuditLogPurgeRule {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuditLogPurgeRule.class);
    private final String auditPath;
    private String ruleName;
    private Set<String> eventTypes;
    private String contentPath;
    private int minimumAge;

    public AbstractAuditLogPurgeRule(String auditPath) {
        this.auditPath = auditPath;
    }

    @Override
    public final String getName() {
        return this.ruleName;
    }

    @Override
    public final Set<String> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public final String getContentPath() {
        return this.contentPath;
    }

    @Override
    public final int getMinimumAge() {
        return this.minimumAge;
    }

    protected final void setUp(Map<String, Object> config) {
        this.ruleName = PropertiesUtil.toString(config.get("auditlog.rule.name"), this.getClass().getName() + System.currentTimeMillis());
        String pathToPurge = PropertiesUtil.toString(config.get("auditlog.rule.contentpath"), null);
        if (pathToPurge != null) {
            if ('/' != pathToPurge.charAt(0)) {
                pathToPurge = '/' + pathToPurge;
            }
            this.contentPath = this.auditPath + pathToPurge;
        } else {
            this.contentPath = null;
        }
        String[] type = PropertiesUtil.toStringArray(config.get("auditlog.rule.types"), null);
        if (type != null && type.length > 0) {
            this.eventTypes = new HashSet<String>(Arrays.asList(type));
        } else {
            type = null;
        }
        this.minimumAge = PropertiesUtil.toInteger(config.get("auditlog.rule.minimumage"), 60);
        LOGGER.info("{} activated", (Object)this);
    }

    protected final void tearDown() {
        LOGGER.info("Deactivating {}...", (Object)this);
        this.ruleName = null;
        this.contentPath = null;
        this.eventTypes = null;
        this.minimumAge = 0;
        LOGGER.info("Deactivated");
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AuditLogPurgeRule)) {
            return false;
        }
        AuditLogPurgeRule other = (AuditLogPurgeRule)obj;
        if (this.contentPath == null ? other.getContentPath() != null : !this.contentPath.equals(other.getContentPath())) {
            return false;
        }
        if (this.eventTypes == null) {
            if (other.getEventTypes() != null) {
                return false;
            }
        } else if (this.eventTypes.isEmpty()) {
            if (!other.getEventTypes().isEmpty()) {
                return false;
            }
        } else {
            Set<String> smallerSet;
            Set<String> biggerSet;
            if (this.eventTypes.size() >= other.getEventTypes().size()) {
                biggerSet = this.eventTypes;
                smallerSet = other.getEventTypes();
            } else {
                biggerSet = other.getEventTypes();
                smallerSet = this.eventTypes;
            }
            for (String current : smallerSet) {
                if (biggerSet.contains(current)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = AbstractAuditLogPurgeRule.hashCode(31, hashCode, this.contentPath);
        if (this.eventTypes == null || this.eventTypes.isEmpty()) {
            hashCode = 31 * hashCode;
        } else {
            for (String current : this.eventTypes) {
                hashCode = AbstractAuditLogPurgeRule.hashCode(31, hashCode, current);
            }
        }
        return hashCode;
    }

    private static final <T> int hashCode(int prime, int hashCode, T object) {
        return prime * hashCode + (object == null ? 0 : object.hashCode());
    }

    public final String toString() {
        return "{name = " + this.ruleName + ", eventTypes = " + this.eventTypes + ", contentPath = " + this.contentPath + ", minimumAge = " + this.minimumAge + "}";
    }
}

