/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.impl.util.AnalyticsAPICallsUtils;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;

public abstract class AbstractApiAdapter {
    public String getSegments(Map params) throws SitecatalystException {
        throw new SitecatalystException("failed in getSegments");
    }

    public String getReportSuites(Map params) throws SitecatalystException {
        throw new SitecatalystException("failed in getReportSuites");
    }

    public String getTrackingServer(Configuration configuration, Map params) throws SitecatalystException {
        throw new SitecatalystException("failed in getTrackingServer");
    }

    public String getEvars(Configuration configuration, String rsid) throws SitecatalystException {
        throw new SitecatalystException("failed in getEvars");
    }

    public String getSuccessEvents(Configuration configuration, String rsid) throws SitecatalystException {
        throw new SitecatalystException("failed in getSuccessEvents");
    }

    public String queueReport(Configuration configuration, JSONObject reportDescription) throws SitecatalystException {
        throw new SitecatalystException("failed in queueReport");
    }

    public String getReport(Configuration configuration, String reportID) throws Exception {
        throw new SitecatalystException("failed in getReport");
    }

    public String getMetrics(Configuration configuration, String rsID) throws SitecatalystException {
        throw new SitecatalystException("failed in getMetrics");
    }

    public String getTrafficVars(Configuration configuration, String rsid) throws SitecatalystException {
        throw new SitecatalystException("failed in getTrafficVars");
    }

    public JsonObject getGlobalCompanyID(Map params) throws SitecatalystException {
        throw new SitecatalystException("failed in getGlobalCompanyID");
    }

    protected abstract ApiKind getApiKind();

    protected abstract Logger getLogger();

    protected JSONArray toJSONArray(String result) throws SitecatalystException {
        try {
            String error = this.getError(result);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            return new JSONArray(result);
        }
        catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    protected JSONArray splitToJSONArray(String s) {
        JSONArray array = new JSONArray();
        for (String piece : s.split(",")) {
            array.put(piece);
        }
        return array;
    }

    protected void checkResults(JSONArray requestArray, JSONArray resultArray) throws JSONException, SitecatalystException {
        int i;
        HashSet<String> rsidSet = new HashSet<String>();
        for (i = 0; i < resultArray.length(); ++i) {
            rsidSet.add(resultArray.getJSONObject(i).getString("rsid"));
        }
        for (i = 0; i < requestArray.length(); ++i) {
            String rsid = requestArray.getString(i);
            if (rsidSet.contains(rsid)) continue;
            throw new SitecatalystException("Report suite with ID " + rsid + "  was not in result");
        }
    }

    protected String getError(String result) throws JSONException {
        return AnalyticsAPICallsUtils.getErrorMessageFromResponse((String)result);
    }

    public static enum ApiKind {
        LEGACY,
        IMS;

    }
}

