/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.core;

import com.adobe.xmp.core.XMPArray;
import com.adobe.xmp.core.XMPNode;
import com.adobe.xmp.core.XMPQualifiers;
import com.adobe.xmp.core.XMPSimple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMPLanguageAlternative {
    XMPArray array = null;

    public XMPArray getArray() {
        return this.array;
    }

    private XMPLanguageAlternative(XMPArray array) {
        this.array = array;
    }

    public static XMPLanguageAlternative newInstance(XMPArray array) {
        boolean foundLangAlt = false;
        if (array.getForm().equals((Object)XMPArray.Form.ALTERNATIVE)) {
            for (XMPNode node : array) {
                if (!(node instanceof XMPSimple)) {
                    return null;
                }
                if (XMPLanguageAlternative.getLanguage(node.adaptTo(XMPSimple.class)) == null) continue;
                foundLangAlt = true;
            }
            if (!array.isEmpty() && !foundLangAlt) {
                return null;
            }
        } else {
            return null;
        }
        return new XMPLanguageAlternative(array);
    }

    public void normalize() {
        if (this.array.isEmpty()) {
            return;
        }
        XMPSimple oldDefault = this.array.getSimple(0);
        String oldXMLLang = null;
        int newDefault = -1;
        if (oldDefault != null) {
            oldXMLLang = XMPLanguageAlternative.getLanguage(oldDefault);
            for (int i = 0; i < this.array.size(); ++i) {
                String normLang;
                XMPSimple langProperty = this.array.getSimple(i);
                if (langProperty == null) continue;
                String xmlLang = XMPLanguageAlternative.getLanguage(langProperty);
                if (xmlLang == null) {
                    if (langProperty.accessQualifiers().size() <= 0) continue;
                    this.cleanupLangAltQualifier(langProperty.accessQualifiers());
                    continue;
                }
                if (langProperty.accessQualifiers().size() > 1) {
                    this.cleanupLangAltQualifier(langProperty.accessQualifiers());
                }
                if (newDefault < 0 && "x-default".equals(xmlLang)) {
                    newDefault = i;
                }
                if ((normLang = this.normalizeLangValue(xmlLang)).equals(xmlLang)) continue;
                langProperty.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", normLang);
            }
            if (newDefault > 0) {
                XMPSimple newDefaultItem = this.array.getSimple(newDefault);
                XMPSimple newEntry = this.array.insertSimple(0, newDefaultItem.getValue());
                newEntry.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", XMPLanguageAlternative.getLanguage(newDefaultItem));
                this.array.remove(newDefault);
            } else if (oldXMLLang == null || oldXMLLang.length() == 0) {
                oldDefault.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", "x-default");
            }
        }
    }

    private void cleanupLangAltQualifier(XMPQualifiers qualifiers) {
        ArrayList<XMPNode> removeList = new ArrayList<XMPNode>();
        for (XMPNode item : qualifiers) {
            if (item instanceof XMPSimple && item.getNamespace().equals("http://www.w3.org/XML/1998/namespace") && item.getName().equals("lang")) continue;
            removeList.add(item);
        }
        for (XMPNode toRemove : removeList) {
            qualifiers.remove(toRemove.getNamespace(), toRemove.getName());
        }
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public int size() {
        return this.array.size();
    }

    public void clear() {
        this.array.clear();
    }

    private static String getLanguage(XMPSimple simple) {
        XMPSimple qual = simple.accessQualifiers().getSimple("http://www.w3.org/XML/1998/namespace", "lang");
        if (qual != null) {
            return qual.getValue();
        }
        return null;
    }

    public XMPSimple setLocalizedText(String language, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value should not be null while setting localized text.");
        }
        String lang = this.normalizeLangValue(language);
        XMPSimple item = null;
        for (int i = 0; i < this.array.size(); ++i) {
            item = this.array.getSimple(i);
            if (item == null) continue;
            String xmlLang = XMPLanguageAlternative.getLanguage(item);
            if (lang == null || !lang.equals(xmlLang)) continue;
            item.setValue(value);
            return item;
        }
        item = "x-default".equals(lang) ? this.array.insertSimple(0, value) : this.array.appendSimple(value);
        item.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", lang);
        return item;
    }

    private XMPArray removeDuplicatedXDefault(XMPArray array) {
        if (array.size() > 1) {
            for (int i = array.size() - 1; i > 0; --i) {
                String currentLang;
                XMPSimple current = array.getSimple(i);
                if (current == null || !(currentLang = XMPLanguageAlternative.getLanguage(current)).equals("x-default")) continue;
                array.remove(i);
            }
        }
        return array;
    }

    public XMPSimple setDefaultText(String language, String value) {
        String lang = this.normalizeLangValue(language);
        if (lang == null || lang.equals("")) {
            lang = "x-default";
        }
        XMPSimple oldDefault = this.array.getSimple(0);
        XMPSimple newSimple = null;
        if (oldDefault != null) {
            String oldDefaultLang = XMPLanguageAlternative.getLanguage(oldDefault);
            if (oldDefaultLang == null) {
                oldDefault.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", "x-default");
                oldDefaultLang = "x-default";
            }
            if ("x-default".equals(oldDefaultLang)) {
                oldDefault.setValue(value);
                oldDefault.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", lang);
                return oldDefault;
            }
        }
        newSimple = this.array.insertSimple(0, value);
        newSimple.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", lang);
        this.array = this.removeDuplicatedXDefault(this.array);
        return newSimple;
    }

    public XMPSimple setDefaultText(String value) {
        if (this.array.size() == 0) {
            XMPSimple newSimple = this.array.insertSimple(0, value);
            newSimple.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", "x-default");
            return newSimple;
        }
        return this.setDefaultText("x-default", value);
    }

    public XMPSimple setDefaultLanguage(String language) {
        String lang = this.normalizeLangValue(language);
        if ("x-default".equals(lang)) {
            return this.getDefaultText();
        }
        Iterator<XMPNode> it = this.array.iterator();
        XMPNode node = null;
        XMPSimple simp = null;
        int cnt = 0;
        String xmlLang = "";
        boolean found = false;
        while (it.hasNext()) {
            node = it.next();
            if (node instanceof XMPSimple && lang.equals(xmlLang = XMPLanguageAlternative.getLanguage(simp = node.adaptTo(XMPSimple.class)))) {
                found = true;
                break;
            }
            ++cnt;
        }
        if (found) {
            if (cnt == 0) {
                return simp;
            }
            XMPSimple oldDefault = this.array.getSimple(0);
            if (oldDefault != null && "x-default".equals(XMPLanguageAlternative.getLanguage(oldDefault))) {
                this.array.remove(0);
                --cnt;
            }
            this.array.remove(cnt);
            XMPSimple newSimp = this.array.insertSimple(0, simp.getValue());
            newSimp.accessQualifiers().setSimple("http://www.w3.org/XML/1998/namespace", "lang", xmlLang);
            return newSimp;
        }
        return null;
    }

    public XMPSimple getLocalizedText(String language) {
        String lang = this.normalizeLangValue(language);
        if (lang == null || lang.equals("") || "x-default".equals(lang)) {
            return this.getDefaultText();
        }
        Iterator<XMPNode> it = this.array.iterator();
        XMPSimple simp = null;
        XMPSimple firstPartialMatch = null;
        XMPNode node = null;
        String xmlLang = "";
        while (it.hasNext()) {
            int pos;
            node = it.next();
            if (!(node instanceof XMPSimple) || (xmlLang = XMPLanguageAlternative.getLanguage(simp = node.adaptTo(XMPSimple.class))) == null) continue;
            if (lang.equals(xmlLang)) {
                return simp;
            }
            while (xmlLang.length() > 0 && (pos = xmlLang.lastIndexOf("-")) >= 0) {
                xmlLang = xmlLang.substring(0, pos);
                if (firstPartialMatch != null || !lang.equals(xmlLang)) continue;
                firstPartialMatch = simp;
            }
        }
        return firstPartialMatch;
    }

    public XMPSimple getDefaultText() {
        XMPSimple simp = this.array.getSimple(0);
        if (simp == null && this.array.size() > 1) {
            for (int i = 1; i < this.array.size() && (simp = this.array.getSimple(i)) == null; ++i) {
            }
        }
        return simp;
    }

    public List<String> getAvailableLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        Iterator<XMPNode> it = this.array.iterator();
        XMPNode current = null;
        String xmlLang = "";
        while (it.hasNext()) {
            current = it.next();
            if (!(current instanceof XMPSimple)) continue;
            xmlLang = XMPLanguageAlternative.getLanguage(current.adaptTo(XMPSimple.class));
            languages.add(xmlLang);
        }
        return languages;
    }

    public XMPSimple removeLocalizedText(String language) {
        String lang = this.normalizeLangValue(language);
        if ("x-default".equals(lang)) {
            return this.removeDefaultText();
        }
        Iterator<XMPNode> it = this.array.iterator();
        XMPNode current = null;
        String xmlLang = "";
        int index = 0;
        while (it.hasNext()) {
            current = it.next();
            if (current instanceof XMPSimple && lang.equals(xmlLang = XMPLanguageAlternative.getLanguage(current.adaptTo(XMPSimple.class)))) {
                current = this.array.remove(index);
                return current.adaptTo(XMPSimple.class);
            }
            ++index;
        }
        return null;
    }

    public XMPSimple removeDefaultText() {
        XMPSimple simple;
        if (!this.array.isEmpty() && (simple = this.array.getSimple(0)) != null) {
            XMPNode removed = this.array.remove(0);
            assert (removed instanceof XMPSimple);
            return removed.adaptTo(XMPSimple.class);
        }
        return null;
    }

    private String normalizeLangValue(String value) {
        if (value == null) {
            return "x-default";
        }
        if ("x-default".equals(value)) {
            return value;
        }
        int subTag = 1;
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '-': 
                case '_': {
                    buffer.append('-');
                    ++subTag;
                    continue block4;
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    if (subTag != 2) {
                        buffer.append(Character.toLowerCase(value.charAt(i)));
                        continue block4;
                    }
                    buffer.append(Character.toUpperCase(value.charAt(i)));
                }
            }
        }
        return buffer.toString();
    }

    public Iterator<XMPNode> iterator() {
        return this.array.iterator();
    }
}

