/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.LcDate;

public final class ISODate
extends LcDate {
    public ISODate() {
        super("en_US", 30);
    }

    public ISODate(int days) {
        super(days, "en_US", 30);
    }

    public ISODate(String date, String locale) {
        super(locale, 30);
        String trimDate = date;
        int tee = date.indexOf(84);
        if (tee >= 0) {
            trimDate = date.substring(0, tee);
        }
        trimDate = trimDate.trim();
        this.mCenturySplit = 30;
        this.setDateSymbols("en_US");
        if (this.parse(trimDate)) {
            this.mYearOfEra -= 1900;
            this.mDays = this.mDayOfMonth < 0 || this.mMonthOfYear < 0 || this.mYearOfEra < 0 ? 0 : this.epoch(this.mDayOfMonth, this.mMonthOfYear, this.mYearOfEra);
        } else {
            this.mDays = 0;
        }
        this.setDateSymbols(locale);
        this.mValid = this.mDays > 0;
    }

    public ISODate(String locale, int centurySplit) {
        super(locale, centurySplit);
    }

    boolean parse(String src) {
        boolean needDashes = src.indexOf(45) >= 0;
        int srcPos = 0;
        int srcLen = src.length();
        this.mYearOfEra = -1;
        this.mMonthOfYear = -1;
        this.mDayOfYear = -1;
        this.mDayOfMonth = -1;
        this.mDayOfWeek = -1;
        if (srcPos + 4 > srcLen) {
            return false;
        }
        int parseRes = this.subParse(src, srcPos, 'Y', 4);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos == srcLen) {
            this.mMonthOfYear = 1;
            this.mDayOfMonth = 1;
            return true;
        }
        if (needDashes) {
            if (!DateTimeUtil.matchChr(src, srcPos, '-', false)) {
                return false;
            }
            ++srcPos;
        }
        if (srcPos + 2 > srcLen) {
            return false;
        }
        parseRes = this.subParse(src, srcPos, 'M', 2);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        if (srcPos == srcLen) {
            this.mDayOfMonth = 1;
            return true;
        }
        if (needDashes) {
            if (!DateTimeUtil.matchChr(src, srcPos, '-', false)) {
                return false;
            }
            ++srcPos;
        }
        if (srcPos + 2 > srcLen) {
            return false;
        }
        parseRes = this.subParse(src, srcPos, 'D', 2);
        if (parseRes < 0) {
            return false;
        }
        srcPos = parseRes;
        return srcPos == srcLen;
    }
}

