/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupEngineOut;
import com.adobe.xfa.text.markup.RTFAttr;
import java.util.ArrayList;
import java.util.List;

public class MarkupRtfOut
extends MarkupEngineOut {
    private final List<String> moFontTable = new ArrayList<String>();
    private final List<GFXColour> moColourTable = new ArrayList<GFXColour>();
    private final boolean mbWriteFontTable;

    public MarkupRtfOut(MarkupAttr pMarkupAttr, List<GFXColour> pColorTable, List<String> pFontTable) {
        super(pMarkupAttr == null ? RTFAttr.GetDefault() : pMarkupAttr);
        boolean bl = this.mbWriteFontTable = pFontTable == null;
        if (pColorTable != null) {
            this.moColourTable.addAll(pColorTable);
        }
        if (pFontTable != null) {
            this.moFontTable.addAll(pFontTable);
        }
    }

    public MarkupRtfOut(MarkupAttr pMarkupAttr, List<GFXColour> pColorTable) {
        this(pMarkupAttr, pColorTable, null);
    }

    public MarkupRtfOut(MarkupAttr pMarkupAttr) {
        this(pMarkupAttr, null, null);
    }

    public MarkupRtfOut() {
        this(null, null, null);
    }

    @Override
    public String translation() {
        this.insertFontTable(this.translationText());
        return super.translation();
    }

    @Override
    protected String outputFontFaceName(TextAttr oAttr) {
        int nIndex;
        StringBuilder sOut = new StringBuilder();
        MarkupAttr pMkAttr = this.markupAttr();
        boolean bFound = false;
        for (nIndex = 0; nIndex < this.moFontTable.size(); ++nIndex) {
            String typeface = this.moFontTable.get(nIndex);
            if (!typeface.equals(oAttr.typeface())) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            this.moFontTable.add(oAttr.typeface());
        }
        sOut.append(pMkAttr.lookup(65));
        sOut.append(Integer.toString(nIndex));
        sOut.append(pMkAttr.delimiter());
        return sOut.toString();
    }

    @Override
    protected String outputColour(GFXColour oColour) {
        int nIndex;
        boolean bFound = false;
        for (nIndex = 0; nIndex < this.moColourTable.size(); ++nIndex) {
            GFXColour test = this.moColourTable.get(nIndex);
            if (!test.equals(oColour)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            this.moColourTable.add(oColour);
        }
        StringBuilder sOut = new StringBuilder(this.markupAttr().lookup(75));
        sOut.append(Integer.toString(nIndex));
        sOut.append(this.markupAttr().delimiter());
        return sOut.toString();
    }

    @Override
    protected boolean isSpecialChar(char c) {
        return c < '\u001f' || c > '~';
    }

    @Override
    protected String convertSpecialChar(char c) {
        if (c < '\u001f' || c > '~') {
            int ic = c & 0xFFFF;
            return Integer.toHexString(ic);
        }
        String sReturn = "";
        return sReturn + c;
    }

    private void insertFontTable(StringBuilder oStrTranslation) {
        if (!this.mbWriteFontTable) {
            return;
        }
        StringBuilder oStrFontTableText = new StringBuilder("{\\fonttbl{}");
        for (int nIndex = 0; nIndex < this.moFontTable.size(); ++nIndex) {
            StringBuilder oStrFontCommand = new StringBuilder("{");
            oStrFontCommand.append(this.markupAttr().lookup(65));
            oStrFontCommand.append(Integer.toString(nIndex));
            oStrFontCommand.append("\\fcharset0\\fprq2 ");
            oStrFontCommand.append(this.moFontTable.get(nIndex));
            oStrFontCommand.append('}');
            oStrFontTableText.append((CharSequence)oStrFontCommand);
        }
        oStrFontTableText.append('}');
        oStrTranslation.insert(0, oStrFontTableText);
        oStrTranslation.insert(0, "{\\rtf1");
        oStrTranslation.append('}');
        int i = oStrTranslation.indexOf("{");
        while (i >= 0) {
            if (oStrTranslation.charAt(i - 1) != '\n' && oStrTranslation.charAt(i - 1) != '\\') {
                oStrTranslation.insert(10, i);
                ++i;
            }
            i = oStrTranslation.indexOf("{", i + 1);
        }
    }
}

